/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.imdg;

import com.hazelcast.jet.IMapJet;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.function.BiFunctionEx;
import com.hazelcast.jet.function.BinaryOperatorEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.Functions;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import java.io.Serializable;
import java.util.Map;

public class MapSourceAndSinks {
    private static final int ITEM_COUNT = 10;
    private static final String MAP_SOURCE = "mapSource";
    private static final String MAP_SINK = "mapSink";
    private static final String MAP_WITH_MERGING_SOURCE = "mapWithMergingSource";
    private static final String MAP_WITH_MERGING_SINK = "mapWithMergingSink";
    private static final String MAP_WITH_UPDATING_SOURCE_SINK = "mapWithUpdatingSourceSink";
    private static final String MAP_WITH_ENTRYPROCESSOR_SOURCE_SINK = "mapWithEntryProcessorSourceSink";
    private final JetInstance jet;

    public MapSourceAndSinks(JetInstance jet) {
        this.jet = jet;
    }

    private static Pipeline mapSourceAndSink(String sourceMapName, String sinkMapName) {
        Pipeline pipeline = Pipeline.create();
        pipeline.drawFrom(Sources.map((String)sourceMapName)).drainTo(Sinks.map((String)sinkMapName));
        return pipeline;
    }

    private static Pipeline mapWithUpdating(String sourceMapName, String sinkMapName) {
        Pipeline pipeline = Pipeline.create();
        pipeline.drawFrom(Sources.map((String)sourceMapName)).map((FunctionEx & Serializable)e -> Util.entry(e.getKey(), (Object)String.valueOf(e.getValue()))).drainTo(Sinks.mapWithUpdating((String)sinkMapName, (BiFunctionEx & Serializable)(oldValue, item) -> (Integer)item.getKey() % 2 == 0 ? oldValue + "-even" : oldValue + "-odd"));
        return pipeline;
    }

    private static Pipeline mapWithMerging(String sourceMapName, String sinkMapName) {
        Pipeline pipeline = Pipeline.create();
        pipeline.drawFrom(Sources.map((String)sourceMapName)).map((FunctionEx & Serializable)e -> Util.entry((Object)"sum", e.getValue())).drainTo(Sinks.mapWithMerging((String)sinkMapName, (BinaryOperatorEx & Serializable)(oldValue, newValue) -> oldValue + newValue));
        return pipeline;
    }

    private static Pipeline mapWithEntryProcessor(String sourceMapName, String sinkMapName) {
        Pipeline pipeline = Pipeline.create();
        pipeline.drawFrom(Sources.map((String)sourceMapName)).drainTo(Sinks.mapWithEntryProcessor((String)sinkMapName, (FunctionEx)Functions.entryKey(), (FunctionEx & Serializable)item -> new IncrementEntryProcessor(5)));
        return pipeline;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("hazelcast.logging.type", "log4j");
        JetInstance jet = Jet.newJetInstance();
        new MapSourceAndSinks(jet).go();
    }

    private void go() {
        try {
            System.out.println("----------Map Source and Sink ----------------");
            MapSourceAndSinks.prepareSampleInput(this.jet, MAP_SOURCE);
            this.jet.newJob(MapSourceAndSinks.mapSourceAndSink(MAP_SOURCE, MAP_SINK)).join();
            MapSourceAndSinks.dumpMap(this.jet, MAP_SINK);
            System.out.println("----------------------------------------------");
            System.out.println("--------------Map with Merging----------------");
            MapSourceAndSinks.prepareSampleInput(this.jet, MAP_WITH_MERGING_SOURCE);
            this.jet.newJob(MapSourceAndSinks.mapWithMerging(MAP_WITH_MERGING_SOURCE, MAP_WITH_MERGING_SINK)).join();
            MapSourceAndSinks.dumpMap(this.jet, MAP_WITH_MERGING_SINK);
            System.out.println("----------------------------------------------");
            System.out.println("------------Map with Updating ----------------");
            MapSourceAndSinks.prepareSampleInput(this.jet, MAP_WITH_UPDATING_SOURCE_SINK);
            this.jet.newJob(MapSourceAndSinks.mapWithUpdating(MAP_WITH_UPDATING_SOURCE_SINK, MAP_WITH_UPDATING_SOURCE_SINK)).join();
            MapSourceAndSinks.dumpMap(this.jet, MAP_WITH_UPDATING_SOURCE_SINK);
            System.out.println("----------------------------------------------");
            System.out.println("----------Map with EntryProcessor ------------");
            MapSourceAndSinks.prepareSampleInput(this.jet, MAP_WITH_ENTRYPROCESSOR_SOURCE_SINK);
            this.jet.newJob(MapSourceAndSinks.mapWithEntryProcessor(MAP_WITH_ENTRYPROCESSOR_SOURCE_SINK, MAP_WITH_ENTRYPROCESSOR_SOURCE_SINK)).join();
            MapSourceAndSinks.dumpMap(this.jet, MAP_WITH_ENTRYPROCESSOR_SOURCE_SINK);
            System.out.println("----------------------------------------------");
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private static void dumpMap(JetInstance instance, String mapName) {
        IMapJet sinkMap = instance.getMap(mapName);
        System.out.println("Sink map size: " + sinkMap.size());
        System.out.println("Sink map entries: ");
        sinkMap.forEach((k, v) -> System.out.println(k + " - " + v));
    }

    private static void prepareSampleInput(JetInstance instance, String sourceMapName) {
        IMapJet sourceMap = instance.getMap(sourceMapName);
        for (int i = 0; i < 10; ++i) {
            sourceMap.put((Object)i, (Object)i);
        }
    }

    static class IncrementEntryProcessor
    implements EntryProcessor<Integer, Integer> {
        private int incrementBy;

        IncrementEntryProcessor(int incrementBy) {
            this.incrementBy = incrementBy;
        }

        public Object process(Map.Entry<Integer, Integer> entry) {
            return entry.setValue(entry.getValue() + this.incrementBy);
        }

        public EntryBackupProcessor<Integer, Integer> getBackupProcessor() {
            return null;
        }
    }
}

