/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.imdg;

import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.jet.ICacheJet;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;

public class CacheSourceAndSink {
    private static final int ITEM_COUNT = 10;
    private static final String SOURCE_NAME = "source";
    private static final String SINK_NAME = "sink";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.setProperty("hazelcast.logging.type", "log4j");
        JetConfig config = new JetConfig();
        config.getHazelcastConfig().addCacheConfig(new CacheSimpleConfig().setName(SOURCE_NAME)).addCacheConfig(new CacheSimpleConfig().setName(SINK_NAME));
        JetInstance jet = Jet.newJetInstance((JetConfig)config);
        try {
            ICacheJet sourceCache = jet.getCacheManager().getCache(SOURCE_NAME);
            for (int i = 0; i < 10; ++i) {
                sourceCache.put((Object)i, (Object)i);
            }
            Pipeline p = Pipeline.create();
            p.drawFrom(Sources.cache((String)SOURCE_NAME)).drainTo(Sinks.cache((String)SINK_NAME));
            jet.newJob(p).join();
            ICacheJet sinkCache = jet.getCacheManager().getCache(SINK_NAME);
            System.out.println("Sink cache entries: ");
            sinkCache.forEach(e -> System.out.println(e.getKey() + "=" + e.getValue()));
        }
        finally {
            Jet.shutdownAll();
        }
    }
}

