/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.imdg;

import com.hazelcast.jet.IListJet;
import com.hazelcast.jet.IMapJet;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.pipeline.GenericPredicates;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.projection.Projection;
import com.hazelcast.projection.Projections;
import com.hazelcast.query.Predicate;
import java.io.IOException;
import java.io.Serializable;

public class MapPredicateAndProjection {
    private static final int ITEM_COUNT = 100000;
    private static final String SOURCE_NAME = "source";
    private static final String SINK_NAME = "sink";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.setProperty("hazelcast.logging.type", "log4j");
        JetConfig config = new JetConfig();
        config.getHazelcastConfig().getSerializationConfig().addPortableFactory(1, (PortableFactory)new TradePortableFactory());
        JetInstance jet = Jet.newJetInstance((JetConfig)config);
        try {
            System.out.println("Creating 100000 entries...");
            IMapJet sourceMap = jet.getMap(SOURCE_NAME);
            for (int i = 0; i < 100000; ++i) {
                String ticker = "ticker-" + i;
                sourceMap.put((Object)ticker, (Object)new Trade(ticker, i));
            }
            Pipeline p1 = Pipeline.create();
            p1.drawFrom(Sources.map((String)SOURCE_NAME, (Predicate)GenericPredicates.lessThan((String)"price", (Comparable)Integer.valueOf(10)), (Projection)Projections.singleAttribute((String)"ticker"))).drainTo(Sinks.list((String)SINK_NAME));
            System.out.println("\n\nExecuting job 1...\n");
            jet.newJob(p1).join();
            IListJet sink = jet.getList(SINK_NAME);
            System.out.println("Sink items using predicates and projections: " + sink.subList(0, sink.size()));
            sink.clear();
            Pipeline p2 = Pipeline.create();
            p2.drawFrom(Sources.map((String)SOURCE_NAME, (Predicate & Serializable)e -> ((Trade)e.getValue()).getPrice() < 10, (FunctionEx & Serializable)e -> ((Trade)e.getValue()).getTicker())).drainTo(Sinks.list((String)SINK_NAME));
            System.out.println("\n\nExecuting job 2...\n");
            jet.newJob(p2).join();
            System.out.println("Sink items using lambdas: " + sink.subList(0, sink.size()));
        }
        finally {
            Jet.shutdownAll();
        }
    }

    static class TradePortableFactory
    implements PortableFactory {
        static final int FACTORY_ID = 1;

        TradePortableFactory() {
        }

        public Portable create(int classId) {
            if (classId == 1) {
                return new Trade();
            }
            throw new UnsupportedOperationException();
        }
    }

    static class Trade
    implements Portable {
        static final int CLASS_ID = 1;
        private String ticker;
        private int price;

        private Trade() {
        }

        Trade(String ticker, int price) {
            this.ticker = ticker;
            this.price = price;
        }

        public String getTicker() {
            return this.ticker;
        }

        public void setTicker(String ticker) {
            this.ticker = ticker;
        }

        public int getPrice() {
            return this.price;
        }

        public void setPrice(int price) {
            this.price = price;
        }

        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 1;
        }

        public void writePortable(PortableWriter writer) throws IOException {
            writer.writeUTF("ticker", this.ticker);
            writer.writeInt("price", this.price);
        }

        public void readPortable(PortableReader reader) throws IOException {
            this.ticker = reader.readUTF("ticker");
            this.price = reader.readInt("price");
        }

        public String toString() {
            return "Trade{ticker='" + this.ticker + '\'' + ", price=" + this.price + '}';
        }
    }
}

