/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.hadoop.parquet;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.examples.hadoop.generated.User;
import com.hazelcast.jet.function.RunnableEx;
import com.hazelcast.jet.hadoop.HadoopSinks;
import com.hazelcast.jet.hadoop.HadoopSources;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Pipeline;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.parquet.avro.AvroParquetInputFormat;
import org.apache.parquet.avro.AvroParquetOutputFormat;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class HadoopParquet {
    private static final String MODULE_DIRECTORY = HadoopParquet.moduleDirectory();
    private static final String INPUT_PATH = MODULE_DIRECTORY + "/hdfs-parquet-input";
    private static final String OUTPUT_PATH = MODULE_DIRECTORY + "/hdfs-parquet-output";
    private static final String INPUT_BUCKET_NAME = "jet-hdfs-parquet-input";
    private static final String OUTPUT_BUCKET_NAME = "jet-hdfs-parquet-output";
    private static final String ACCESS_KEY = "";
    private static final String SECRET_KEY = "";

    private static Pipeline buildPipeline(Configuration configuration) {
        Pipeline p = Pipeline.create();
        p.readFrom(HadoopSources.inputFormat((Configuration)configuration, (BiFunctionEx & Serializable)(s, user) -> user)).filter((PredicateEx & Serializable)user -> user.get(3).equals(Boolean.TRUE)).peek().writeTo(HadoopSinks.outputFormat((Configuration)configuration, (FunctionEx & Serializable)o -> null, (FunctionEx & Serializable)o -> o));
        return p;
    }

    public static void main(String[] args) throws Exception {
        new HadoopParquet().go();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void go() throws Exception {
        Path inputPath = new Path(INPUT_PATH);
        Path outputPath = new Path(OUTPUT_PATH);
        FileSystem.get((Configuration)new Configuration()).delete(outputPath, true);
        try {
            this.createParquetFile();
            JetInstance jet = Jet.bootstrappedInstance();
            Configuration jobConfig = this.createJobConfig(Job.getInstance(), inputPath, outputPath);
            jet.newJob(HadoopParquet.buildPipeline(jobConfig)).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void s3() throws Exception {
        Path inputPath = new Path("s3a://jet-hdfs-parquet-input/");
        Path outputPath = new Path("s3a://jet-hdfs-parquet-output/");
        try {
            JetInstance jet = Jet.bootstrappedInstance();
            Configuration jobConfig = this.createJobConfig(this.jobWithS3AccessKeys(), inputPath, outputPath);
            jet.newJob(HadoopParquet.buildPipeline(jobConfig)).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private Job jobWithS3AccessKeys() throws IOException {
        Job job = Job.getInstance();
        Configuration configuration = job.getConfiguration();
        configuration.set("fs.s3a.access.key", "");
        configuration.set("fs.s3a.secret.key", "");
        return job;
    }

    private Configuration createJobConfig(Job job, Path inputPath, Path outputPath) throws IOException {
        job.setInputFormatClass(AvroParquetInputFormat.class);
        job.setOutputFormatClass(AvroParquetOutputFormat.class);
        AvroParquetOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        AvroParquetOutputFormat.setSchema((Job)job, (Schema)User.SCHEMA$);
        AvroParquetInputFormat.addInputPath((Job)job, (Path)inputPath);
        AvroParquetInputFormat.setAvroReadSchema((Job)job, (Schema)User.SCHEMA$);
        return job.getConfiguration();
    }

    private void createParquetFile() throws IOException {
        Path inputPath = new Path(INPUT_PATH);
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        fs.delete(inputPath, true);
        Path filePath = new Path(inputPath, "file.parquet");
        ParquetWriter writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)filePath).withRowGroupSize(0x8000000)).withPageSize(0x100000)).withSchema(User.SCHEMA$).withConf(new Configuration())).withCompressionCodec(CompressionCodecName.SNAPPY)).withValidation(false)).withDictionaryEncoding(false)).build();
        IntStream.range(0, 100).mapToObj(i -> new User("name" + i, "pass" + i, i, i % 2 == 0)).forEach(user -> Util.uncheckRun((RunnableEx & Serializable)() -> writer.write((Object)user)));
        writer.close();
        fs.close();
    }

    private static String moduleDirectory() {
        String resourcePath = HadoopParquet.class.getClassLoader().getResource("").getPath();
        return Paths.get(resourcePath, new String[0]).getParent().getParent().toString();
    }
}

