/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.hadoop.avro;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.examples.hadoop.generated.User;
import com.hazelcast.jet.function.RunnableEx;
import com.hazelcast.jet.hadoop.HadoopSinks;
import com.hazelcast.jet.hadoop.HadoopSources;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Pipeline;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;

public class HadoopAvro {
    private static final String MODULE_DIRECTORY = HadoopAvro.moduleDirectory();
    private static final String INPUT_PATH = MODULE_DIRECTORY + "/hadoop-avro-input";
    private static final String OUTPUT_PATH = MODULE_DIRECTORY + "/hadoop-avro-output";

    public static void main(String[] args) throws Exception {
        Path inputPath = new Path(INPUT_PATH);
        Path outputPath = new Path(OUTPUT_PATH);
        FileSystem.get((Configuration)new Configuration()).delete(outputPath, true);
        HadoopAvro.createAvroFile();
        HadoopAvro.executeSample(HadoopAvro.createJobConfig(inputPath, outputPath));
    }

    public static void executeSample(Configuration configuration) {
        try {
            JetInstance jet = Jet.bootstrappedInstance();
            jet.newJob(HadoopAvro.buildPipeline(configuration)).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private static void createAvroFile() throws IOException {
        Path inputPath = new Path(INPUT_PATH);
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        fs.delete(inputPath, true);
        DataFileWriter fileWriter = new DataFileWriter((DatumWriter)new SpecificDatumWriter(User.class));
        fileWriter.create(User.SCHEMA$, (OutputStream)fs.create(new Path(inputPath, "file.avro")));
        IntStream.range(0, 100).mapToObj(i -> new User("name" + i, "pass" + i, i, i % 2 == 0)).forEach(user -> Util.uncheckRun((RunnableEx & Serializable)() -> fileWriter.append((Object)user)));
        fileWriter.close();
        fs.close();
    }

    private static Pipeline buildPipeline(Configuration configuration) {
        Pipeline p = Pipeline.create();
        p.readFrom(HadoopSources.inputFormat((Configuration)configuration, (BiFunctionEx & Serializable)(key, val) -> (User)((Object)((Object)key.datum())))).filter((PredicateEx & Serializable)user -> user.get(3).equals(Boolean.TRUE)).peek().writeTo(HadoopSinks.outputFormat((Configuration)configuration, AvroKey::new, (FunctionEx & Serializable)user -> null));
        return p;
    }

    private static String moduleDirectory() {
        String resourcePath = HadoopAvro.class.getClassLoader().getResource("").getPath();
        return Paths.get(resourcePath, new String[0]).getParent().getParent().toString();
    }

    public static Configuration createJobConfig(Path inputPath, Path outputPath) throws IOException {
        FileSystem.get((Configuration)new Configuration()).delete(outputPath, true);
        Job job = Job.getInstance();
        job.setInputFormatClass(AvroKeyInputFormat.class);
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        AvroKeyInputFormat.addInputPath((Job)job, (Path)inputPath);
        AvroKeyOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        AvroJob.setInputKeySchema((Job)job, (Schema)User.SCHEMA$);
        AvroJob.setOutputKeySchema((Job)job, (Schema)User.SCHEMA$);
        return job.getConfiguration();
    }
}

