/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.grpc;

import com.hazelcast.jet.examples.grpc.BrokerInfoReply;
import com.hazelcast.jet.examples.grpc.BrokerInfoRequest;
import com.hazelcast.jet.examples.grpc.BrokerServiceGrpc;
import com.hazelcast.jet.examples.grpc.datamodel.Broker;
import io.grpc.stub.StreamObserver;
import java.util.Map;

public class BrokerServiceImpl
extends BrokerServiceGrpc.BrokerServiceImplBase {
    private final Map<Integer, Broker> brokers;

    public BrokerServiceImpl(Map<Integer, Broker> brokers) {
        this.brokers = brokers;
    }

    @Override
    public StreamObserver<BrokerInfoRequest> brokerInfo(final StreamObserver<BrokerInfoReply> responseObserver) {
        return new StreamObserver<BrokerInfoRequest>(){

            public void onNext(BrokerInfoRequest request) {
                String brokerName = ((Broker)BrokerServiceImpl.this.brokers.get(request.getId())).name();
                BrokerInfoReply reply = BrokerInfoReply.newBuilder().setBrokerName(brokerName).build();
                responseObserver.onNext((Object)reply);
            }

            public void onError(Throwable t) {
                t.printStackTrace();
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }
}

