/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.files.unifiedapi;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.avro.AvroSinks;
import com.hazelcast.jet.examples.files.unifiedapi.Trade;
import com.hazelcast.jet.examples.files.unifiedapi.generated.AvroTrade;
import com.hazelcast.jet.hadoop.HadoopSinks;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.file.FileFormat;
import com.hazelcast.jet.pipeline.file.FileSources;
import java.io.Serializable;
import java.nio.file.Paths;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetOutputFormat;

public class TradeWriter {
    public static void main(String[] args) throws Exception {
        Schema tradeAvroSchema = ReflectData.get().getSchema(AvroTrade.class);
        org.apache.hadoop.mapreduce.Job job = org.apache.hadoop.mapreduce.Job.getInstance();
        job.setOutputFormatClass(AvroParquetOutputFormat.class);
        AvroParquetOutputFormat.setOutputPath((org.apache.hadoop.mapreduce.Job)job, (Path)new Path("./data/trades.parquet"));
        AvroParquetOutputFormat.setSchema((org.apache.hadoop.mapreduce.Job)job, (Schema)tradeAvroSchema);
        BatchSource source = FileSources.files((String)Paths.get("data/trades", new String[0]).toAbsolutePath().toString()).glob("*jsonl").format((FileFormat)FileFormat.json(Trade.class)).build();
        Pipeline p = Pipeline.create();
        BatchStage trades = p.readFrom(source);
        trades.map((FunctionEx & Serializable)trade -> trade.getTime() + "," + trade.getTicker() + "," + trade.getQuantity() + "," + trade.getPrice()).writeTo(Sinks.files((String)"data/trades.csv"));
        trades.map((FunctionEx & Serializable)trade -> new AvroTrade(trade.getTime(), trade.getTicker(), trade.getQuantity(), trade.getPrice())).writeTo(AvroSinks.files((String)"data/trades.avro", AvroTrade.class, (Schema)tradeAvroSchema));
        trades.map((FunctionEx & Serializable)trade -> new AvroTrade(trade.getTime(), trade.getTicker(), trade.getQuantity(), trade.getPrice())).writeTo(HadoopSinks.outputFormat((Configuration)job.getConfiguration(), (FunctionEx & Serializable)trade -> null, (FunctionEx & Serializable)trade -> trade)).setLocalParallelism(1);
        JetInstance jet = Jet.bootstrappedInstance();
        Job jetJob = jet.newJob(p);
        Thread.sleep(1000L);
        jetJob.cancel();
        jet.shutdown();
    }
}

