/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.files.unifiedapi;

import com.hazelcast.function.ComparatorEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.examples.files.unifiedapi.Trade;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.file.FileFormat;
import com.hazelcast.jet.pipeline.file.FileSources;
import java.io.Serializable;
import java.nio.file.Paths;

public class TradeAnalyzerJob {
    private static Pipeline buildPipeline(String sourceDir, String type) {
        BatchStage trades;
        Pipeline p = Pipeline.create();
        switch (type) {
            case "csv": {
                BatchSource source = FileSources.files((String)sourceDir).glob("*." + type).format((FileFormat)FileFormat.csv(Trade.class)).build();
                trades = p.readFrom(source);
                break;
            }
            case "json": {
                BatchSource source = FileSources.files((String)sourceDir).glob("*." + type + "*").format((FileFormat)FileFormat.json(Trade.class)).build();
                trades = p.readFrom(source);
                break;
            }
            case "avro": {
                BatchSource source = FileSources.files((String)sourceDir).glob("*." + type).format((FileFormat)FileFormat.avro(Trade.class)).build();
                trades = p.readFrom(source);
                break;
            }
            case "parquet": {
                BatchSource parquetSource = FileSources.files((String)sourceDir).glob("*." + type).format((FileFormat)FileFormat.parquet()).useHadoopForLocalFiles(true).build();
                trades = p.readFrom(parquetSource).map((FunctionEx & Serializable)avroTrade -> new Trade(avroTrade.getTime(), avroTrade.getTicker().toString(), avroTrade.getQuantity(), avroTrade.getPrice()));
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + type);
            }
        }
        trades.groupingKey(Trade::getTicker).aggregate(AggregateOperations.summingLong(Trade::getQuantity)).sort((ComparatorEx & Serializable)(o1, o2) -> Long.compare((Long)o1.getValue(), (Long)o2.getValue())).writeTo(Sinks.logger());
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage:");
            System.err.println("  " + TradeAnalyzerJob.class.getSimpleName() + " <csv|json|avro|parquet> <sourceDir>");
            System.exit(1);
        }
        String type = args[0];
        String sourceDir = args[1];
        Pipeline p = TradeAnalyzerJob.buildPipeline(Paths.get(sourceDir, new String[0]).toAbsolutePath().toString(), type);
        JetInstance instance = Jet.bootstrappedInstance();
        try {
            instance.newJob(p).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }
}

