/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.files.avro;

import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.avro.AvroSinks;
import com.hazelcast.jet.examples.files.avro.User;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.map.IMap;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;

public class AvroSink {
    public static final String MAP_NAME = "userMap";
    public static final String DIRECTORY_NAME;
    private JetInstance jet;

    private static Pipeline buildPipeline() {
        Pipeline p = Pipeline.create();
        Schema schema = AvroSink.schemaForUser();
        p.readFrom(Sources.map((String)MAP_NAME)).map(Map.Entry::getValue).writeTo(AvroSinks.files((String)DIRECTORY_NAME, User.class, (Schema)schema));
        return p;
    }

    public static void main(String[] args) throws Exception {
        new AvroSink().go();
    }

    private void go() {
        try {
            this.setup();
            this.jet.newJob(AvroSink.buildPipeline()).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private void setup() {
        this.jet = Jet.bootstrappedInstance();
        IMap map = this.jet.getMap(MAP_NAME);
        for (int i = 0; i < 100; ++i) {
            User user = new User("User" + i, "pass" + i, i, i % 2 == 0);
            map.put((Object)user.getUsername(), (Object)user);
        }
    }

    private static Schema schemaForUser() {
        return (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)User.class.getSimpleName()).namespace(User.class.getPackage().getName())).fields().name("username").type().stringType().noDefault().name("password").type().stringType().noDefault().name("age").type().intType().noDefault().name("status").type().booleanType().noDefault().endRecord();
    }

    static {
        Path path = Paths.get(AvroSink.class.getClassLoader().getResource("").getPath(), new String[0]);
        DIRECTORY_NAME = path.getParent().getParent().toString() + "/users";
    }
}

