/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.files;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.function.RunnableEx;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SalesJsonAnalyzer {
    private static Pipeline buildPipeline(String sourceDir) {
        Pipeline p = Pipeline.create();
        BatchSource source = Sources.filesBuilder((String)sourceDir).glob("*.json").build((FunctionEx & Serializable)path -> SalesJsonAnalyzer.readJsonArray(path, SalesRecord.class));
        p.readFrom(source).filter((PredicateEx & Serializable)record -> record.getPrice() < 30.0).groupingKey(SalesRecord::getPaymentType).aggregate(AggregateOperations.counting()).writeTo(Sinks.logger());
        return p;
    }

    private static <T> Stream<T> readJsonArray(Path filePath, final Type type) throws IOException {
        final Gson gson = new Gson();
        final JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(filePath, StandardCharsets.UTF_8));
        reader.beginArray();
        Iterator iterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                try {
                    return reader.hasNext();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public T next() {
                return gson.fromJson(reader, type);
            }
        };
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 256), false).onClose((Runnable)((RunnableEx & Serializable)() -> ((JsonReader)reader).close()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage:");
            System.err.println("  " + SalesJsonAnalyzer.class.getSimpleName() + " <sourceDir>");
            System.exit(1);
        }
        String sourceDir = args[0];
        Pipeline p = SalesJsonAnalyzer.buildPipeline(sourceDir);
        JetInstance instance = Jet.bootstrappedInstance();
        try {
            instance.newJob(p).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private static class SalesRecord
    implements Serializable {
        private long time;
        private String product;
        private double price;
        private String paymentType;
        private String name;
        private String address;
        private String city;
        private String state;
        private String country;

        private SalesRecord() {
        }

        public long getTime() {
            return this.time;
        }

        public String getProduct() {
            return this.product;
        }

        public double getPrice() {
            return this.price;
        }

        public String getPaymentType() {
            return this.paymentType;
        }

        public String getName() {
            return this.name;
        }

        public String getCity() {
            return this.city;
        }

        public String getState() {
            return this.state;
        }

        public String getCountry() {
            return this.country;
        }

        public String getAddress() {
            return this.address;
        }

        public String toString() {
            return "SalesRecord{time=" + this.time + ", product='" + this.product + '\'' + ", price=" + this.price + ", paymentType='" + this.paymentType + '\'' + ", name='" + this.name + '\'' + ", address='" + this.address + '\'' + ", city='" + this.city + '\'' + ", state='" + this.state + '\'' + ", country='" + this.country + '\'' + '}';
        }
    }
}

