/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.files.avro;

import com.hazelcast.jet.IMapJet;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.avro.AvroSources;
import com.hazelcast.jet.examples.files.avro.AvroSink;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import java.io.Serializable;
import java.nio.file.Paths;
import org.apache.avro.reflect.ReflectDatumReader;

public class AvroSource {
    private JetInstance jet;

    private static Pipeline buildPipeline() {
        Pipeline p = Pipeline.create();
        p.drawFrom(AvroSources.filesBuilder((String)AvroSink.DIRECTORY_NAME, ReflectDatumReader::new).sharedFileSystem(true).build()).map((FunctionEx & Serializable)user -> Util.entry((Object)user.getUsername(), (Object)user)).drainTo(Sinks.map((String)"userMap"));
        return p;
    }

    public static void main(String[] args) throws Exception {
        new AvroSource().go();
    }

    private void go() {
        try {
            this.setup();
            this.jet.newJob(AvroSource.buildPipeline()).join();
            IMapJet map = this.jet.getMap("userMap");
            System.out.println("Map Size: " + map.size());
            map.forEach((key, value) -> System.out.println(key + " - " + value));
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private void setup() {
        if (!Paths.get(AvroSink.DIRECTORY_NAME, new String[0]).toFile().exists()) {
            System.out.println("Avro files directory does not exist, please run " + AvroSink.class.getSimpleName() + " first to create it.");
            System.exit(0);
        }
        this.jet = Jet.newJetInstance();
        Jet.newJetInstance();
    }
}

