/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.files.cloud;

import com.hazelcast.function.ComparatorEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.Functions;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.file.FileSources;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class S3WordCount {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage:");
            System.err.println("  " + S3WordCount.class.getSimpleName() + " <inputPath>");
            System.exit(1);
        }
        String inputPath = args[0];
        try {
            JetInstance jet = Jet.bootstrappedInstance();
            System.out.print("\nCounting words from " + inputPath);
            long start = System.nanoTime();
            Pipeline p = new S3WordCount().buildPipeline(inputPath);
            jet.newJob(p).join();
            System.out.println("Done in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " milliseconds.");
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private Pipeline buildPipeline(String inputPath) {
        Pattern regex = Pattern.compile("\\W+");
        BatchSource source = FileSources.files((String)inputPath).option("fs.s3a.aws.credentials.provider", "com.amazonaws.auth.profile.ProfileCredentialsProvider").build();
        Pipeline p = Pipeline.create();
        p.readFrom(source).flatMap((FunctionEx & Serializable)line -> Traversers.traverseArray((Object[])regex.split(line.toLowerCase())).filter(w -> !w.isEmpty())).groupingKey(Functions.wholeItem()).aggregate(AggregateOperations.counting()).aggregate(AggregateOperations.topN((int)10, (ComparatorEx)ComparatorEx.comparing(Map.Entry::getValue))).writeTo(Sinks.logger());
        return p;
    }
}

