/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.eventjournal;

import com.hazelcast.cache.ICache;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.pipeline.JournalInitialPosition;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CacheJournalSource {
    private static final String CACHE_NAME = "cache";
    private static final String SINK_NAME = "list";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        JetConfig jetConfig = CacheJournalSource.getJetConfig();
        JetInstance jet = Jet.newJetInstance((JetConfig)jetConfig);
        Jet.newJetInstance((JetConfig)jetConfig);
        try {
            Pipeline p = Pipeline.create();
            p.readFrom(Sources.cacheJournal((String)CACHE_NAME, (JournalInitialPosition)JournalInitialPosition.START_FROM_OLDEST)).withoutTimestamps().map(Map.Entry::getValue).writeTo(Sinks.list((String)SINK_NAME));
            jet.newJob(p);
            ICache cache = jet.getCacheManager().getCache(CACHE_NAME);
            for (int i = 0; i < 1000; ++i) {
                cache.put((Object)i, (Object)i);
            }
            TimeUnit.SECONDS.sleep(3L);
            System.out.println("Read " + jet.getList(SINK_NAME).size() + " entries from cache journal.");
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private static JetConfig getJetConfig() {
        return new JetConfig().configureHazelcast(c -> c.addCacheConfig(new CacheSimpleConfig().setName(CACHE_NAME)).getCacheConfig(CACHE_NAME).getEventJournalConfig().setEnabled(true).setCapacity(10000).setTimeToLiveSeconds(10));
    }
}

