/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.elastic;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Observable;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.elastic.ElasticClients;
import com.hazelcast.jet.elastic.ElasticSources;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import java.io.Serializable;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;

public class ElasticSourceExample {
    private static final String ROLES_OBSERVABLE = "roles";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Pipeline p = Pipeline.create();
            BatchSource elasticsearch = ElasticSources.elastic((SupplierEx & Serializable)() -> ElasticClients.client((String)"localhost", (int)9200), SearchRequest::new, (FunctionEx & Serializable)hit -> {
                Map map = hit.getSourceAsMap();
                return Tuple2.tuple2((Object)((String)map.get("role")), (Object)((String)map.get("name")));
            });
            p.readFrom(elasticsearch).groupingKey(Tuple2::getKey).aggregate(AggregateOperations.mapping(Tuple2::getValue, (AggregateOperation1)AggregateOperations.toList())).writeTo(Sinks.observable((String)ROLES_OBSERVABLE));
            JetInstance jet = Jet.bootstrappedInstance();
            Observable roles = jet.getObservable(ROLES_OBSERVABLE);
            roles.addObserver(System.out::println);
            jet.newJob(p).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }
}

