/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.earlyresults.support;

import com.hazelcast.collection.IList;
import com.hazelcast.collection.ItemEvent;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.jet.datamodel.WindowResult;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Paint;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public final class TradingVolumeGui {
    private static final int WINDOW_X = 100;
    private static final int WINDOW_Y = 100;
    private static final int WINDOW_WIDTH = 1200;
    private static final int WINDOW_HEIGHT = 650;
    private static final int TIME_RANGE = 60;
    private static final int Y_RANGE_UPPER_INITIAL = 3000;
    private static final double SCALE_Y = 1000000.0;
    private final IList<WindowResult<Long>> volumeList;
    private final boolean[] finalResultFlags = new boolean[60];
    private final BarRenderer renderer = new BarRenderer(){

        public Paint getItemPaint(int row, int column) {
            return column >= TradingVolumeGui.this.finalResultFlags.length || TradingVolumeGui.this.finalResultFlags[column] ? Color.BLUE : Color.GRAY;
        }
    };

    public TradingVolumeGui(IList<WindowResult<Long>> volumeList) {
        this.volumeList = volumeList;
        EventQueue.invokeLater(this::startGui);
    }

    private void startGui() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        CategoryPlot plot = this.createChartFrame((CategoryDataset)dataset);
        plot.getRangeAxis().setRange(0.0, 3000.0);
        Long ts = 2L;
        while (ts <= 60L) {
            dataset.addValue(0.0, (Comparable)((Object)""), (Comparable)ts);
            ts = ts + 2L;
        }
        ItemAddedListener<WindowResult> itemListener = tse -> EventQueue.invokeLater(() -> {
            Long x = tse.end() / 1000L;
            double y = (double)((Long)tse.result()).longValue() / 1000000.0;
            int col = dataset.getColumnIndex((Comparable)x);
            if (col < this.finalResultFlags.length) {
                boolean finalResultReceived = this.finalResultFlags[col];
                if (finalResultReceived) {
                    return;
                }
                this.finalResultFlags[col] = !tse.isEarly();
            }
            dataset.addValue(y, (Comparable)((Object)""), (Comparable)x);
        });
        this.volumeList.addItemListener(itemListener, true);
    }

    private CategoryPlot createChartFrame(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart((String)"Trading Volume Over Time", (String)"Time", (String)"Trading Volume, millions USD", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.DARK_GRAY);
        plot.getDomainAxis().setCategoryMargin(0.0);
        plot.setRangeGridlinePaint((Paint)Color.DARK_GRAY);
        this.renderer.setBarPainter((BarPainter)new StandardBarPainter());
        this.renderer.setShadowPaint((Paint)Color.WHITE);
        plot.setRenderer((CategoryItemRenderer)this.renderer);
        JFrame frame = new JFrame();
        frame.setBackground(Color.WHITE);
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Hazelcast Jet Early Window Results Sample");
        frame.setBounds(100, 100, 1200, 650);
        frame.setLayout(new BorderLayout());
        frame.add((Component)new ChartPanel(chart));
        frame.setVisible(true);
        return plot;
    }

    static interface ItemAddedListener<T>
    extends ItemListener<T> {
        public void item(T var1);

        default public void itemRemoved(ItemEvent<T> event) {
        }

        default public void itemAdded(ItemEvent<T> event) {
            this.item(event.getItem());
        }
    }
}

