/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.earlyresults;

import com.hazelcast.collection.IList;
import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.datamodel.WindowResult;
import com.hazelcast.jet.examples.earlyresults.support.TradeGenerator;
import com.hazelcast.jet.examples.earlyresults.support.TradingVolumeGui;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.WindowDefinition;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public final class TradingVolumeOverTime {
    private static final String VOLUME_LIST_NAME = "trading-volume";
    private static final int TRADES_PER_SEC = 3000;
    private static final int DURATION_SECONDS = 60;

    private static Pipeline buildPipeline() {
        Pipeline p = Pipeline.create();
        p.readFrom(TradeGenerator.tradeSource(3000, 60L)).withNativeTimestamps(5000L).window((WindowDefinition)WindowDefinition.tumbling((long)TimeUnit.SECONDS.toMillis(2L)).setEarlyResultsPeriod(20L)).aggregate(AggregateOperations.summingLong((ToLongFunctionEx & Serializable)trade -> trade.getQuantity() * trade.getPrice())).writeTo(Sinks.list((String)VOLUME_LIST_NAME));
        return p;
    }

    public static void main(String[] args) {
        JetInstance jet = Jet.bootstrappedInstance();
        new TradingVolumeGui((IList<WindowResult<Long>>)jet.getList(VOLUME_LIST_NAME));
        try {
            jet.newJob(TradingVolumeOverTime.buildPipeline()).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }
}

