/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.UrlXmlConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.DuplicateInstanceNameException;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;

class HazelcastInstanceLoader {
    HazelcastInstanceLoader() {
    }

    public static HazelcastInstance createInstance(FilterConfig filterConfig) throws ServletException {
        String instanceName = filterConfig.getInitParameter("instance-name");
        String configLocation = filterConfig.getInitParameter("config-location");
        UrlXmlConfig config = null;
        if (HazelcastInstanceLoader.isEmpty(configLocation) && HazelcastInstanceLoader.isEmpty(instanceName)) {
            return Hazelcast.getDefaultInstance();
        }
        URL configUrl = null;
        if (!HazelcastInstanceLoader.isEmpty(configLocation)) {
            try {
                configUrl = filterConfig.getServletContext().getResource(configLocation);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (configUrl == null) {
                configUrl = ConfigLoader.locateConfig((String)configLocation);
            }
        }
        if (configUrl != null) {
            try {
                config = new UrlXmlConfig(configUrl);
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (config == null) {
            config = new XmlConfigBuilder().build();
        }
        if (instanceName != null) {
            config.setInstanceName(instanceName);
            HazelcastInstance instance = Hazelcast.getHazelcastInstanceByName((String)instanceName);
            if (instance == null) {
                try {
                    instance = Hazelcast.newHazelcastInstance((Config)config);
                }
                catch (DuplicateInstanceNameException ignored) {
                    instance = Hazelcast.getHazelcastInstanceByName((String)instanceName);
                }
            }
            return instance;
        }
        return Hazelcast.newHazelcastInstance((Config)config);
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

