/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IMap;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class WebFilter
implements Filter {
    private static final ConcurrentMap<String, String> mapOriginalSessions = new ConcurrentHashMap<String, String>(1000);
    private static final ConcurrentMap<String, HazelSession> mapSessions = new ConcurrentHashMap<String, HazelSession>(1000);
    private ServletContext servletContext = null;
    private String clusterMapName = "none";
    private int maxInactiveInterval = 30;
    private static Logger logger = Logger.getLogger(WebFilter.class.getName());
    private static final boolean DEBUG = true;
    private static final String SESSION_URL_PHRASE = ";jsessionid=";
    private static final String HAZELCAST_REQUEST = "*hazelcast-request";

    public void init(FilterConfig config) throws ServletException {
        String sessionTimeoutValue = config.getInitParameter("session-timeout");
        this.servletContext = config.getServletContext();
        if (sessionTimeoutValue != null) {
            this.maxInactiveInterval = Integer.parseInt(sessionTimeoutValue.trim());
        }
        this.clusterMapName = "_web_" + this.servletContext.getServletContextName();
    }

    public static void destroySession(HttpSession originalSession) {
        HazelSession hazelSession;
        String hazelcastSessionId = (String)mapOriginalSessions.remove(originalSession.getId());
        if (hazelcastSessionId != null && (hazelSession = (HazelSession)mapSessions.remove(hazelcastSessionId)) != null) {
            WebFilter.log("Destroying session " + hazelSession);
            hazelSession.webFilter.destroySession(hazelSession);
        }
    }

    static void log(Object obj) {
        logger.log(Level.FINEST, obj.toString());
        System.out.println(obj.toString());
    }

    boolean urlRewriteEnabled() {
        return true;
    }

    void changeSessionId(HazelSession session) {
        String oldId = session.getId();
        mapSessions.remove(oldId);
        this.getClusterMap().remove((Object)oldId);
        session.id = WebFilter.generateSessionId();
        while (mapSessions.containsKey(session.getId())) {
            session.id = WebFilter.generateSessionId();
        }
        mapSessions.put(session.getId(), session);
    }

    HazelSession createNewSession(String requestedSessionId) {
        String id;
        String string = id = requestedSessionId == null ? WebFilter.generateSessionId() : requestedSessionId;
        while (mapSessions.containsKey(id)) {
            id = WebFilter.generateSessionId();
        }
        return this.getSessionWithId(id, true);
    }

    void destroySession(HazelSession session) {
        String id = session.id;
        session.destroy();
        mapSessions.remove(id);
        WebFilter.log(id + " Removing from cluster " + this.getClusterMap().remove((Object)id));
    }

    public IMap getClusterMap() {
        return Hazelcast.getMap((String)this.clusterMapName);
    }

    HazelSession getSessionWithId(String sessionId, boolean create) {
        HazelSession session = (HazelSession)mapSessions.get(sessionId);
        if (session == null && create) {
            session = new HazelSession(this, sessionId);
            session.setMaxInactiveInterval(this.maxInactiveInterval * 60);
            HazelSession oldSessionInfo = mapSessions.putIfAbsent(sessionId, session);
            if (oldSessionInfo != null) {
                session = oldSessionInfo;
            }
        }
        return session;
    }

    private static void addCookieForSession(RequestWrapper req, String sessionId) {
        Cookie sessionCookie = new Cookie("JSESSIONID", sessionId);
        sessionCookie.setPath(req.getContextPath());
        sessionCookie.setMaxAge(-1);
        req.res.addCookie(sessionCookie);
        WebFilter.log(req.getContextPath() + " ADDING JSESSIONID COOKIE " + sessionCookie.getValue() + " now cookie.path " + sessionCookie.getPath());
    }

    private static synchronized String generateSessionId() {
        char[] chars;
        String id = UUID.randomUUID().toString();
        StringBuilder sb = new StringBuilder();
        for (char c : chars = id.toCharArray()) {
            if (c == '-') continue;
            if (Character.isLetter(c)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        id = "HZ" + sb.toString();
        WebFilter.log("Randomly generated session Id " + id);
        return id;
    }

    private static void removeCookieForSession(RequestWrapper req, String sessionId) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                String value = cookie.getValue();
                String path = cookie.getPath();
                if (!req.getContextPath().equals(path) || !name.equals("JSESSIONID") || !value.equals(sessionId)) continue;
                WebFilter.log("Found old sessionId cookie DELETING " + value);
                cookie.setMaxAge(0);
                req.res.addCookie(cookie);
                break;
            }
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        WebFilter.log("FILTERING %%55555.. " + req.getClass().getName());
        if (!(req instanceof HttpServletRequest)) {
            chain.doFilter(req, res);
        } else {
            if (req instanceof RequestWrapper) {
                WebFilter.log("Request is instance ! continue...");
                chain.doFilter(req, res);
                return;
            }
            HttpServletRequest httpReq = (HttpServletRequest)req;
            Cookie[] cookies = httpReq.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    String name = cookie.getName();
                    String value = cookie.getValue();
                    String path = cookie.getPath();
                    if (!name.equalsIgnoreCase("JSESSIONID")) continue;
                    WebFilter.log(path + " Request has JSESSIONID cookie " + value);
                }
            }
            boolean newRequest = req.getAttribute(HAZELCAST_REQUEST) == null;
            ResponseWrapper resWrapper = new ResponseWrapper((HttpServletResponse)res);
            RequestWrapper reqWrapper = new RequestWrapper(httpReq, resWrapper);
            resWrapper.setRequest(reqWrapper);
            if (!newRequest) {
                RequestWrapper existingReq = (RequestWrapper)((Object)req.getAttribute(HAZELCAST_REQUEST));
                reqWrapper.setRequestedSessionId(existingReq.hazelSession, existingReq.requestedSessionId, existingReq.requestedSessionIdFromCookie);
            } else {
                reqWrapper.setExtractSessionId();
            }
            req = null;
            res = null;
            httpReq = null;
            HazelSession session = null;
            String sessionId = null;
            session = reqWrapper.getSession(false);
            if (session != null) {
                sessionId = session.getId();
            }
            if (session != null && session.expired(System.currentTimeMillis())) {
                WebFilter.log("doFilter got session expiration for " + session.getId());
                this.destroySession(session);
            }
            chain.doFilter((ServletRequest)reqWrapper, (ServletResponse)resWrapper);
            req = null;
            session = reqWrapper.getSession(false);
            if (session != null) {
                sessionId = session.getId();
            }
            if (session != null) {
                if (!session.valid.get()) {
                    WebFilter.log("Session is not valid. removing cookie for " + sessionId);
                    WebFilter.removeCookieForSession(reqWrapper, sessionId);
                    return;
                }
                Enumeration attsNames = session.getAttributeNames();
                HashMap<String, Object> mapData = null;
                while (attsNames.hasMoreElements()) {
                    String attName = (String)attsNames.nextElement();
                    Object value = session.getAttribute(attName);
                    WebFilter.log(attName + " session " + value + " serializable : " + (value instanceof Serializable));
                    if (!(value instanceof Serializable)) continue;
                    if (mapData == null) {
                        mapData = new HashMap();
                    }
                    mapData.put(attName, value);
                }
                boolean sessionChanged = false;
                Data data = session.writeObject(mapData);
                sessionChanged = session.sessionChanged(data);
                WebFilter.log(sessionId + " session changed? " + sessionChanged);
                if (sessionChanged) {
                    if (data == null) {
                        mapData = new HashMap<String, Object>();
                        data = session.writeObject(mapData);
                    }
                    WebFilter.log("PUTTING SESSION " + sessionId + "  values " + mapData);
                    if (session.knownToCluster()) {
                        this.getClusterMap().put((Object)sessionId, (Object)data);
                    } else {
                        Object old = this.getClusterMap().putIfAbsent((Object)sessionId, (Object)data);
                        int tryCount = 1;
                        while (old != null) {
                            this.changeSessionId(session);
                            old = this.getClusterMap().putIfAbsent((Object)sessionId, (Object)data);
                            if (tryCount++ < 3) continue;
                            throw new RuntimeException("SessinId Generator is no good!");
                        }
                        session.setKnownToCluster(true);
                    }
                }
                session.setLastAccessed();
                session.setNew(false);
            }
        }
    }

    public void destroy() {
        for (HazelSession session : mapSessions.values()) {
            this.destroySession(session);
        }
        mapSessions.clear();
    }

    private class HazelSession
    implements HttpSession {
        private Data currentSessionData = null;
        public int minSize = -1;
        public int maxSize = -1;
        AtomicLong maxInactiveInterval = new AtomicLong(1800000L);
        AtomicLong creationTime = new AtomicLong();
        AtomicLong lastAccessedTime = new AtomicLong();
        AtomicBoolean valid = new AtomicBoolean(true);
        AtomicBoolean isNew = new AtomicBoolean(true);
        AtomicBoolean knownToCluster = new AtomicBoolean(false);
        String id = null;
        HttpSession originalSession;
        WebFilter webFilter;

        public HazelSession(WebFilter webFilter2, String sessionId) {
            this.webFilter = webFilter2;
            this.id = sessionId;
            this.creationTime.set(System.currentTimeMillis());
            this.lastAccessedTime.set(System.currentTimeMillis());
        }

        public HttpSession getOriginalSession() {
            return this.originalSession;
        }

        public void setOriginalSession(HttpSession originalSession) {
            this.originalSession = originalSession;
            WebFilter.log(this + " setting original session " + originalSession);
            mapOriginalSessions.put(originalSession.getId(), this.id);
        }

        public boolean expired(long currentTime) {
            long maxInactive = this.maxInactiveInterval.get();
            if (maxInactive < 0L) {
                return false;
            }
            return currentTime - this.lastAccessedTime.get() >= maxInactive;
        }

        public Object getAttribute(String name) {
            this.checkState();
            return this.originalSession.getAttribute(name);
        }

        public Enumeration getAttributeNames() {
            this.checkState();
            return this.originalSession.getAttributeNames();
        }

        public long getCreationTime() {
            this.checkState();
            return this.creationTime.get();
        }

        public String getId() {
            this.checkState();
            return this.id;
        }

        public long getLastAccessedTime() {
            this.checkState();
            return this.lastAccessedTime.get();
        }

        public int getMaxInactiveInterval() {
            return (int)(this.maxInactiveInterval.get() / 1000L);
        }

        public ServletContext getServletContext() {
            return WebFilter.this.servletContext;
        }

        public HttpSessionContext getSessionContext() {
            this.checkState();
            return null;
        }

        public Object getValue(String name) {
            this.checkState();
            return this.originalSession.getValue(name);
        }

        public String[] getValueNames() {
            this.checkState();
            return this.originalSession.getValueNames();
        }

        public void invalidate() {
            this.checkState();
            this.originalSession.invalidate();
            WebFilter.this.destroySession(this);
        }

        public boolean isNew() {
            this.checkState();
            return this.isNew.get();
        }

        public boolean knownToCluster() {
            return this.knownToCluster.get();
        }

        public void putValue(String name, Object value) {
            this.checkState();
            this.originalSession.setAttribute(name, value);
        }

        public void removeAttribute(String name) {
            this.checkState();
            this.originalSession.removeAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.checkState();
            this.originalSession.setAttribute(name, value);
        }

        public void removeValue(String name) {
            this.checkState();
            this.removeAttribute(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean sessionChanged(Data data) {
            WebFilter.log(this.currentSessionData + " vs " + data);
            WebFilter.log(IOUtil.toObject((Data)this.currentSessionData) + " vs " + IOUtil.toObject((Data)data));
            try {
                if (data == null) {
                    boolean bl = this.currentSessionData != null;
                    return bl;
                }
                if (this.currentSessionData == null) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = !data.equals((Object)this.currentSessionData);
                return bl;
            }
            finally {
                this.currentSessionData = data;
            }
        }

        public void setKnownToCluster(boolean knownToCluster) {
            this.knownToCluster.set(knownToCluster);
        }

        public void setLastAccessed() {
            this.checkState();
            this.lastAccessedTime.set(System.currentTimeMillis());
        }

        public void setMaxInactiveInterval(int maxInactiveSeconds) {
            WebFilter.log("setting max interval seconds to " + maxInactiveSeconds);
            if (maxInactiveSeconds < 0) {
                maxInactiveSeconds = -1;
            }
            this.maxInactiveInterval.set((long)maxInactiveSeconds * 1000L);
        }

        public void setNew(boolean isNew) {
            this.isNew.set(isNew);
        }

        public synchronized Data writeObject(Object obj) {
            if (obj == null) {
                return null;
            }
            try {
                Data data = ThreadContext.get().toData(obj);
                int size = data.size();
                if (this.minSize == -1 || this.minSize > size) {
                    this.minSize = size;
                }
                if (this.maxSize == -1 || this.maxSize < size) {
                    this.maxSize = size;
                }
                return data;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        void destroy() {
            this.valid.set(false);
        }

        private void checkState() {
            if (!this.valid.get()) {
                throw new IllegalStateException("Session is invalid!");
            }
        }
    }

    class ResponseWrapper
    extends HttpServletResponseWrapper {
        RequestWrapper req;

        public ResponseWrapper(HttpServletResponse original) {
            super(original);
            this.req = null;
        }

        public String encodeURL(String url) {
            if (url == null) {
                throw new NullPointerException("URL can not be null");
            }
            if (!WebFilter.this.urlRewriteEnabled()) {
                return url;
            }
            return this.encodeURL(url, WebFilter.SESSION_URL_PHRASE);
        }

        public String extractSessionId(String url) {
            int prefix = url.indexOf(WebFilter.SESSION_URL_PHRASE);
            if (prefix != -1) {
                int start = prefix + WebFilter.SESSION_URL_PHRASE.length();
                int suffix = url.indexOf("?", start);
                if (suffix < 0) {
                    suffix = url.indexOf("#", start);
                }
                if (suffix <= prefix) {
                    return url.substring(start);
                }
                return url.substring(start, suffix);
            }
            return null;
        }

        public RequestWrapper getRequest() {
            return this.req;
        }

        public void setRequest(RequestWrapper req) {
            this.req = req;
        }

        private String encodeURL(String url, String sessionURLPhrase) {
            if (url == null) {
                throw new NullPointerException("URL can not be null");
            }
            if (url != null || this.req == null || this.req.isRequestedSessionIdFromCookie()) {
                int prefix = url.indexOf(sessionURLPhrase);
                if (prefix != -1) {
                    int suffix = url.indexOf("?", prefix);
                    if (suffix < 0) {
                        suffix = url.indexOf("#", prefix);
                    }
                    if (suffix <= prefix) {
                        return url.substring(0, prefix);
                    }
                    return url.substring(0, prefix) + url.substring(suffix);
                }
                return url;
            }
            HazelSession session = this.req.getSession(false);
            if (session == null) {
                return url;
            }
            if (!session.valid.get()) {
                return url;
            }
            String id = session.getId();
            int prefix = url.indexOf(sessionURLPhrase);
            if (prefix != -1) {
                int suffix = url.indexOf("?", prefix);
                if (suffix < 0) {
                    suffix = url.indexOf("#", prefix);
                }
                if (suffix <= prefix) {
                    return url.substring(0, prefix + sessionURLPhrase.length()) + id;
                }
                return url.substring(0, prefix + sessionURLPhrase.length()) + id + url.substring(suffix);
            }
            int suffix = url.indexOf(63);
            if (suffix < 0) {
                suffix = url.indexOf(35);
            }
            if (suffix < 0) {
                return url + sessionURLPhrase + id;
            }
            return url.substring(0, suffix) + sessionURLPhrase + id + url.substring(suffix);
        }
    }

    class RequestWrapper
    extends HttpServletRequestWrapper {
        HazelSession hazelSession;
        final ResponseWrapper res;
        final ConcurrentMap<String, Object> atts;
        final long creationTime;
        String requestedSessionId;
        boolean requestedSessionIdValid;
        boolean requestedSessionIdFromCookie;
        boolean requestedSessionIdFromURL;

        public RequestWrapper(HttpServletRequest req, ResponseWrapper res) {
            super(req);
            this.hazelSession = null;
            this.atts = new ConcurrentHashMap<String, Object>();
            this.requestedSessionId = null;
            this.requestedSessionIdValid = true;
            this.requestedSessionIdFromCookie = false;
            this.requestedSessionIdFromURL = false;
            WebFilter.log("REQ Wrapping " + req.getClass().getName());
            this.res = res;
            req.setAttribute(WebFilter.HAZELCAST_REQUEST, (Object)this);
            this.creationTime = System.nanoTime();
        }

        void setExtractSessionId() {
            Cookie[] cookies = ((HttpServletRequest)this.getRequest()).getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equalsIgnoreCase("JSESSIONID")) continue;
                    this.requestedSessionId = cookie.getValue();
                    this.requestedSessionIdFromCookie = true;
                    WebFilter.log("Extracted sessionId from cookie " + this.requestedSessionId);
                }
            }
            if (this.requestedSessionId == null) {
                logger.log(Level.FINEST, "contextPath : " + this.getContextPath());
                logger.log(Level.FINEST, "queryString : " + this.getQueryString());
                logger.log(Level.FINEST, "requestURI : " + this.getRequestURI());
                logger.log(Level.FINEST, "requestURL : " + this.getRequestURL());
                this.requestedSessionId = this.res.extractSessionId(this.getRequestURL().toString());
                WebFilter.log("Extracted sessionId from URL " + this.requestedSessionId);
                if (this.requestedSessionId != null) {
                    this.requestedSessionIdFromURL = true;
                }
            }
        }

        public void setRequestedSessionId(HazelSession hazelSession, String requestedSessionId, boolean fromCookie) {
            this.hazelSession = hazelSession;
            this.requestedSessionId = requestedSessionId;
            this.requestedSessionIdFromCookie = fromCookie;
            this.requestedSessionIdFromURL = !this.requestedSessionIdFromCookie;
        }

        public RequestDispatcher getRequestDispatcher(final String path) {
            final ServletRequest original = this.getRequest();
            return new RequestDispatcher(){

                public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    WebFilter.log("FORWARD " + original);
                    original.getRequestDispatcher(path).forward(original, servletResponse);
                }

                public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    original.getRequestDispatcher(path).forward(original, servletResponse);
                }
            };
        }

        public Enumeration getAttributeNames() {
            if (this.atts.size() == 0) {
                return new IteratorEnumeration(null);
            }
            return new IteratorEnumeration(this.atts.keySet().iterator());
        }

        public String getRequestedSessionId() {
            if (this.requestedSessionId != null) {
                return this.requestedSessionId;
            }
            return super.getRequestedSessionId();
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public HazelSession getSession(boolean create) {
            if (this.hazelSession != null) {
                return this.hazelSession;
            }
            String requestedSessionId = this.getRequestedSessionId();
            HazelSession session = null;
            if (requestedSessionId != null) {
                session = WebFilter.this.getSessionWithId(requestedSessionId, false);
            }
            WebFilter.log(requestedSessionId + " is requestedSessionId and  getSession : " + session);
            if (session == null && create) {
                HttpSession originalSession = super.getSession(true);
                session = WebFilter.this.createNewSession(requestedSessionId);
                session.setOriginalSession(originalSession);
                this.hazelSession = session;
                if (requestedSessionId != null) {
                    Map mapSession = (Map)WebFilter.this.getClusterMap().remove((Object)requestedSessionId);
                    WebFilter.log(session + " Reloading from map.. " + mapSession);
                    WebFilter.log("ContextPath " + this.getContextPath());
                    WebFilter.log("pathInfo " + this.getPathInfo());
                    WebFilter.log("pathtranslated " + this.getPathTranslated());
                    WebFilter.log("requesturi " + this.getRequestURI());
                    if (mapSession != null) {
                        Set entries = mapSession.entrySet();
                        for (Map.Entry entry : entries) {
                            session.setAttribute((String)entry.getKey(), entry.getValue());
                        }
                    }
                    WebFilter.removeCookieForSession(this, requestedSessionId);
                    Cookie[] cookies = this.getCookies();
                    if (cookies != null) {
                        for (Cookie cookie : cookies) {
                            String name = cookie.getName();
                            String value = cookie.getValue();
                            String path = cookie.getPath();
                            if (!this.getContextPath().equals(path) || !name.equals("JSESSIONID") || !value.equals(requestedSessionId)) continue;
                            WebFilter.log("Found old sessionId cookie DELETING " + value);
                            cookie.setMaxAge(0);
                            this.res.addCookie(cookie);
                            break;
                        }
                    }
                }
                WebFilter.addCookieForSession(this, session.getId());
            }
            return session;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return this.requestedSessionIdFromCookie;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return this.isRequestedSessionIdFromURL();
        }

        public boolean isRequestedSessionIdFromURL() {
            return this.requestedSessionIdFromURL;
        }

        public boolean isRequestedSessionIdValid() {
            return this.requestedSessionIdValid;
        }

        public void setRequestedSessionIdValid(boolean valid) {
            this.requestedSessionIdValid = valid;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IteratorEnumeration
    implements Enumeration<String> {
        Iterator<String> it = null;

        IteratorEnumeration(Iterator<String> it) {
            this.it = it;
        }

        @Override
        public boolean hasMoreElements() {
            return this.it != null && this.it.hasNext();
        }

        @Override
        public String nextElement() {
            if (this.it == null) {
                return null;
            }
            return this.it.next();
        }
    }
}

