/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.web.ServletBase;
import com.hazelcast.web.WebFilter;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ServletWrapper
extends ServletBase {
    GenericServlet base = null;
    public static final String HAZELCAST_BASE_SERVLET_CLASS = "*hazelcast-base-servlet-class";

    private void initBase(ServletConfig servletConfig) {
        if (this.base == null) {
            String baseClassName = servletConfig.getInitParameter(HAZELCAST_BASE_SERVLET_CLASS);
            try {
                this.base = (GenericServlet)Class.forName(baseClassName).newInstance();
                this.debug("Will use base servlet class " + this.base);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.initBase(servletConfig);
        this.base.init(this.getServletConfig());
    }

    public void destroy() {
        this.base.destroy();
    }

    public String getInitParameter(String name) {
        return this.base.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.base.getInitParameterNames();
    }

    public void service(ServletRequest req, ServletResponse res) throws IOException, ServletException {
        ServletRequest reqHazel;
        if (!(req instanceof WebFilter.RequestWrapper) && (reqHazel = (ServletRequest)req.getAttribute("*hazelcast-request")) != null) {
            req = reqHazel;
        }
        this.base.service(req, res);
    }

    public String getServiceName() {
        return this.base.getServletName();
    }

    public String getServletInfo() {
        return this.base.getServletInfo();
    }
}

