/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web.tomcat;

import com.hazelcast.web.tomcat.HazelcastAttribute;
import com.hazelcast.web.tomcat.HazelcastConstants;
import com.hazelcast.web.tomcat.HazelcastSessionFacade;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class HazelcastValve
extends ValveBase
implements HazelcastConstants {
    public static ThreadLocal<Long> requestLocal = new ThreadLocal();
    private static AtomicLong lastRequestId = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            long requestId = lastRequestId.addAndGet(1L);
            requestLocal.set(requestId);
            this.getNext().invoke(request, response);
            HazelcastSessionFacade ses = (HazelcastSessionFacade)request.getSession();
            List<HazelcastAttribute> touchedList = ses.getTouchedAttributes(requestId);
            for (HazelcastAttribute hattribute : touchedList) {
                hazelAttributes.put((Object)hattribute.getKey(), (Object)hattribute);
            }
        }
        finally {
            requestLocal.remove();
        }
    }
}

