/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IMap;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.nio.Data;
import com.hazelcast.web.Context;
import com.hazelcast.web.SnapshotEvent;
import com.hazelcast.web.SnapshotListener;
import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class WebFilter
implements Filter {
    protected static Logger logger = Logger.getLogger(WebFilter.class.getName());
    private static final boolean DEBUG = false;
    private static final String SESSION_URL_PHRASE = ";jsessionid=";
    public static final String HAZELCAST_REQUEST = "*hazelcast-request";
    private static ConcurrentMap<String, AppContext> mapApps = new ConcurrentHashMap<String, AppContext>(10);
    private AppContext app = null;
    private static boolean appsSharingSessions = false;
    private static ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(5);

    public static synchronized AppContext ensureServletContext(ServletContext servletContext) {
        AppContext app = WebFilter.getAppContext(servletContext.getServletContextName());
        if (app == null) {
            app = new AppContext(servletContext);
            WebFilter.setAppContext(servletContext.getServletContextName(), app);
        }
        return app;
    }

    public static synchronized AppContext getAppContext(String servletContextName) {
        if (appsSharingSessions) {
            servletContextName = "_hz_shared_app";
        }
        return (AppContext)mapApps.get(servletContextName);
    }

    public static synchronized ServletContext getServletContext(ServletContext original) {
        AppContext app = WebFilter.getAppContext(original.getServletContextName());
        if (app == null) {
            return original;
        }
        return app.getOriginalServletContext();
    }

    public static synchronized AppContext setAppContext(String servletContextName, AppContext app) {
        if (appsSharingSessions) {
            servletContextName = "_hz_shared_app";
        }
        WebFilter.log(appsSharingSessions + " PUTTING.. " + servletContextName + " appobj " + app);
        return mapApps.put(servletContextName, app);
    }

    static void log(Object obj) {
    }

    private static void addCookieForSession(RequestWrapper req, String sessionId) {
        Cookie sessionCookie = new Cookie("JSESSIONID", sessionId);
        sessionCookie.setPath(req.getContextPath());
        sessionCookie.setMaxAge(-1);
        req.res.addCookie(sessionCookie);
    }

    private static synchronized String generateSessionId() {
        char[] chars;
        String id = UUID.randomUUID().toString();
        StringBuilder sb = new StringBuilder();
        for (char c : chars = id.toCharArray()) {
            if (c == '-') continue;
            if (Character.isLetter(c)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        id = "HZ" + sb.toString();
        return id;
    }

    private static AppContext getAppContext(ServletContext servletContext) {
        return WebFilter.getAppContext(servletContext.getServletContextName());
    }

    private static void removeCookieForSession(RequestWrapper req, String sessionId) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                String value = cookie.getValue();
                String path = cookie.getPath();
                if (!req.getContextPath().equals(path) || !name.equals("JSESSIONID") || !value.equals(sessionId)) continue;
                cookie.setMaxAge(0);
                req.res.addCookie(cookie);
                break;
            }
        }
    }

    public void destroy() {
        mapApps.remove(this.app.getServletContextName());
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        WebFilter.log("doFILTER");
        if (!(req instanceof HttpServletRequest)) {
            chain.doFilter(req, res);
        } else {
            ServletRequestEvent event;
            if (req instanceof RequestWrapper) {
                chain.doFilter(req, res);
                return;
            }
            if (req.getAttribute(HAZELCAST_REQUEST) != null) {
                chain.doFilter(req, res);
                return;
            }
            HttpServletRequest httpReq = (HttpServletRequest)req;
            ResponseWrapper resWrapper = new ResponseWrapper(this.app, (HttpServletResponse)res);
            RequestWrapper reqWrapper = new RequestWrapper(this.app, httpReq, resWrapper);
            resWrapper.setRequest(reqWrapper);
            ServletRequestEvent servletRequestEvent = event = this.app.lsRequestListeners.size() == 0 ? null : new ServletRequestEvent(this.app.getOriginalServletContext(), (ServletRequest)reqWrapper);
            if (event != null) {
                executor.execute(new Runnable(){

                    public void run() {
                        for (ServletRequestListener listener : ((WebFilter)WebFilter.this).app.lsRequestListeners) {
                            listener.requestInitialized(event);
                        }
                    }
                });
            }
            req = null;
            res = null;
            httpReq = null;
            HazelSession session = null;
            String sessionId = null;
            session = reqWrapper.getSession(false);
            if (session != null) {
                sessionId = session.getId();
            }
            if (session != null && session.expired(System.currentTimeMillis())) {
                this.app.destroySession(session);
            }
            chain.doFilter((ServletRequest)reqWrapper, (ServletResponse)resWrapper);
            req = null;
            session = reqWrapper.getSession(false);
            if (session != null) {
                sessionId = session.getId();
            }
            if (session != null) {
                if (!session.valid.get()) {
                    WebFilter.removeCookieForSession(reqWrapper, sessionId);
                    return;
                }
                Enumeration attsNames = session.getAttributeNames();
                HashMap<String, Object> mapData = null;
                while (attsNames.hasMoreElements()) {
                    String attName = (String)attsNames.nextElement();
                    Object value = session.getAttribute(attName);
                    if (!(value instanceof Serializable)) continue;
                    if (mapData == null) {
                        mapData = new HashMap<String, Object>();
                    }
                    mapData.put(attName, value);
                }
                boolean sessionChanged = false;
                Data data = session.writeObject(mapData);
                sessionChanged = session.sessionChanged(data);
                if (sessionChanged) {
                    if (data == null) {
                        mapData = new HashMap();
                        data = session.writeObject(mapData);
                    }
                    if (session.knownToCluster()) {
                        this.app.getClusterMap().put((Object)sessionId, (Object)data);
                    } else {
                        Object old = this.app.getClusterMap().putIfAbsent((Object)sessionId, (Object)data);
                        int tryCount = 1;
                        while (old != null) {
                            this.app.changeSessionId(session);
                            old = this.app.getClusterMap().putIfAbsent((Object)sessionId, (Object)data);
                            if (tryCount++ < 3) continue;
                            throw new RuntimeException("SessinId Generator is no good!");
                        }
                        session.setKnownToCluster(true);
                    }
                }
                session.setLastAccessed();
                session.setNew(false);
            }
            this.app.getSnapshot().requestTime((System.nanoTime() - reqWrapper.creationTime) / 1000L);
            if (event != null) {
                executor.execute(new Runnable(){

                    public void run() {
                        for (ServletRequestListener listener : ((WebFilter)WebFilter.this).app.lsRequestListeners) {
                            listener.requestDestroyed(event);
                        }
                    }
                });
            }
        }
    }

    public void init(FilterConfig config) throws ServletException {
        String sessionTimeoutValue;
        int maxInactiveInterval = 30;
        String appsSharingSessionsValue = config.getInitParameter("apps-sharing-sessions");
        if (appsSharingSessionsValue != null) {
            appsSharingSessions = Boolean.valueOf(appsSharingSessionsValue.trim());
        }
        if ((sessionTimeoutValue = config.getInitParameter("session-timeout")) != null) {
            maxInactiveInterval = Integer.parseInt(sessionTimeoutValue.trim());
        }
        this.app = WebFilter.ensureServletContext(config.getServletContext());
        this.app.init(maxInactiveInterval);
        int listenerCount = Integer.parseInt(config.getInitParameter("listener-count"));
        for (int i = 0; i < listenerCount; ++i) {
            String listenerClass = config.getInitParameter("listener" + i);
            try {
                Object listener = Class.forName(listenerClass).newInstance();
                if (listener instanceof HttpSessionListener) {
                    this.app.lsSessionListeners.add((HttpSessionListener)listener);
                }
                if (listener instanceof HttpSessionAttributeListener) {
                    this.app.lsSessionAttListeners.add((HttpSessionAttributeListener)listener);
                }
                if (listener instanceof ServletContextListener) {
                    this.app.lsContextListeners.add((ServletContextListener)listener);
                }
                if (listener instanceof ServletContextAttributeListener) {
                    this.app.lsContextAttListeners.add((ServletContextAttributeListener)listener);
                }
                if (listener instanceof ServletRequestListener) {
                    this.app.lsRequestListeners.add((ServletRequestListener)listener);
                }
                if (!(listener instanceof ServletRequestAttributeListener)) continue;
                this.app.lsRequestAttListeners.add((ServletRequestAttributeListener)listener);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.app.setReady();
    }

    static {
        executor.scheduleAtFixedRate(new Controller(), 0L, 60L, TimeUnit.SECONDS);
        executor.scheduleAtFixedRate(new Runnable(){

            public void run() {
                for (AppContext appContext : mapApps.values()) {
                    appContext.getSnapshot();
                }
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    private static class Snapshot {
        private final long createTime;
        private final long lifeTime;
        private final AppContext context;
        public AtomicLong aveRequestTime = new AtomicLong();
        public AtomicLong minRequestTime = new AtomicLong(Long.MAX_VALUE);
        public AtomicLong maxRequestTime = new AtomicLong(Long.MIN_VALUE);
        public AtomicLong numberOfRequests = new AtomicLong();
        public AtomicInteger createdSessions = new AtomicInteger();
        public AtomicInteger destroyedSessions = new AtomicInteger();
        private final Object averageLock = new Object();
        public AtomicLong tempNumberOfRequests = new AtomicLong();
        public AtomicLong tempTotalReqTime = new AtomicLong();

        public Snapshot(AppContext context, long snapshotLifeTime) {
            this.createTime = System.currentTimeMillis();
            this.lifeTime = snapshotLifeTime;
            this.context = context;
        }

        public SnapshotEvent createSnapshotEvent() {
            this.flush();
            long minReqT = this.minRequestTime.get() == Long.MAX_VALUE ? 0L : this.minRequestTime.get();
            long maxReqT = this.maxRequestTime.get() == Long.MIN_VALUE ? 0L : this.maxRequestTime.get();
            return new SnapshotEvent(this.context.getOriginalServletContext(), this.createdSessions.get(), this.destroyedSessions.get(), minReqT, maxReqT, this.aveRequestTime.get(), this.numberOfRequests.get());
        }

        public boolean invalid() {
            return System.currentTimeMillis() - this.createTime > this.lifeTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestTime(long nano) {
            if (nano < this.minRequestTime.get()) {
                this.minRequestTime.set(nano);
            }
            if (nano > this.maxRequestTime.get()) {
                this.maxRequestTime.set(nano);
            }
            long tempCount = this.tempNumberOfRequests.incrementAndGet();
            this.tempTotalReqTime.addAndGet(nano);
            if (tempCount > 10000L) {
                Object object = this.averageLock;
                synchronized (object) {
                    if (tempCount > 10000L) {
                        this.flush();
                    }
                }
            }
        }

        void flush() {
            long tempReqCount = this.tempNumberOfRequests.get();
            if (tempReqCount > 0L) {
                long temReqTime = this.tempTotalReqTime.get();
                long aveReqTime = this.aveRequestTime.get();
                long reqs = this.numberOfRequests.get();
                long totalTime = aveReqTime * reqs + temReqTime;
                long totalReqCount = reqs + tempReqCount;
                long newAve = totalTime / totalReqCount;
                this.aveRequestTime.set(newAve);
                this.numberOfRequests.set(totalReqCount);
                this.tempNumberOfRequests.set(0L);
                this.tempTotalReqTime.set(0L);
            }
        }
    }

    private static class HazelSession
    implements HttpSession {
        private byte[] hash = null;
        private MessageDigest md = null;
        public int minSize = -1;
        public int maxSize = -1;
        AtomicLong maxInactiveInterval = new AtomicLong(1800000L);
        AtomicLong creationTime = new AtomicLong();
        AtomicLong lastAccessedTime = new AtomicLong();
        AtomicBoolean valid = new AtomicBoolean(true);
        AtomicBoolean isNew = new AtomicBoolean(true);
        AtomicBoolean knownToCluster = new AtomicBoolean(false);
        String id = null;
        ConcurrentMap<String, Object> atts = new ConcurrentHashMap<String, Object>();
        AppContext context = null;

        public HazelSession(AppContext context, String sessionId) {
            this.context = context;
            try {
                this.md = MessageDigest.getInstance("md5");
            }
            catch (NoSuchAlgorithmException e) {
                // empty catch block
            }
            this.id = sessionId;
            this.creationTime.set(System.currentTimeMillis());
            this.lastAccessedTime.set(System.currentTimeMillis());
            final List<HttpSessionListener> lsSessionListeners = context.lsSessionListeners;
            if (lsSessionListeners.size() > 0) {
                executor.execute(new Runnable(){

                    public void run() {
                        HttpSessionEvent event = new HttpSessionEvent((HttpSession)HazelSession.this);
                        for (HttpSessionListener listener : lsSessionListeners) {
                            listener.sessionCreated(event);
                        }
                    }
                });
            }
            context.getSnapshot().createdSessions.incrementAndGet();
        }

        public boolean expired(long currentTime) {
            long maxInactive = this.maxInactiveInterval.get();
            if (maxInactive < 0L) {
                return false;
            }
            return currentTime - this.lastAccessedTime.get() >= maxInactive;
        }

        public Object getAttribute(String name) {
            this.checkState();
            return this.atts.get(name);
        }

        public Enumeration getAttributeNames() {
            this.checkState();
            if (this.atts.size() == 0) {
                return new IteratorEnumeration(null);
            }
            return new IteratorEnumeration(this.atts.keySet().iterator());
        }

        public long getCreationTime() {
            this.checkState();
            return this.creationTime.get();
        }

        public String getId() {
            this.checkState();
            return this.id;
        }

        public long getLastAccessedTime() {
            this.checkState();
            return this.lastAccessedTime.get();
        }

        public int getMaxInactiveInterval() {
            return (int)(this.maxInactiveInterval.get() / 1000L);
        }

        public ServletContext getServletContext() {
            return this.context.getOriginalServletContext();
        }

        public HttpSessionContext getSessionContext() {
            this.checkState();
            return null;
        }

        public Object getValue(String name) {
            this.checkState();
            return this.atts.get(name);
        }

        public String[] getValueNames() {
            this.checkState();
            return this.atts.keySet().toArray(new String[this.atts.size()]);
        }

        public byte[] hash(Data data) {
            if (data == null) {
                return null;
            }
            this.md.reset();
            data.digest(this.md);
            return this.md.digest();
        }

        public void invalidate() {
            this.checkState();
            this.context.destroySession(this);
        }

        public boolean isNew() {
            this.checkState();
            return this.isNew.get();
        }

        public boolean knownToCluster() {
            return this.knownToCluster.get();
        }

        public void putValue(String name, Object value) {
            this.checkState();
            this.setAttribute(name, value);
        }

        public void removeAttribute(final String name) {
            this.checkState();
            final Object oldValue = this.atts.remove(name);
            if (oldValue != null) {
                List<HttpSessionAttributeListener> lsSessionAttributeListeners;
                if (oldValue instanceof HttpSessionBindingListener) {
                    executor.execute(new Runnable(){

                        public void run() {
                            HttpSessionBindingEvent bindingEvent = new HttpSessionBindingEvent((HttpSession)HazelSession.this, name, oldValue);
                            ((HttpSessionBindingListener)oldValue).valueUnbound(bindingEvent);
                        }
                    });
                }
                if ((lsSessionAttributeListeners = this.context.lsSessionAttListeners).size() > 0) {
                    executor.execute(new Runnable(){

                        public void run() {
                            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)HazelSession.this, name, oldValue);
                            for (HttpSessionAttributeListener listener : lsSessionAttributeListeners) {
                                listener.attributeRemoved(event);
                            }
                        }
                    });
                }
            }
        }

        public void removeValue(String name) {
            this.checkState();
            this.removeAttribute(name);
        }

        public boolean sessionChanged(Data data) {
            if (data == null) {
                if (this.hash == null) {
                    return false;
                }
                this.hash = null;
                return true;
            }
            byte[] newHash = this.hash(data);
            if (this.hash == null) {
                this.hash = newHash;
                return true;
            }
            boolean same = Arrays.equals(this.hash, newHash);
            if (!same) {
                this.hash = newHash;
                return true;
            }
            return false;
        }

        public void setAttribute(final String name, final Object value) {
            this.checkState();
            if (value == null) {
                this.removeAttribute(name);
            } else {
                List<HttpSessionAttributeListener> lsSessionAttributeListeners;
                final Object oldValue = this.atts.put(name, value);
                if (value instanceof HttpSessionBindingListener) {
                    executor.execute(new Runnable(){

                        public void run() {
                            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)HazelSession.this, name, value);
                            HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
                            listener.valueBound(event);
                        }
                    });
                }
                if (oldValue != null && oldValue instanceof HttpSessionBindingListener) {
                    executor.execute(new Runnable(){

                        public void run() {
                            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)HazelSession.this, name, oldValue);
                            HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
                            listener.valueUnbound(event);
                        }
                    });
                }
                if ((lsSessionAttributeListeners = this.context.lsSessionAttListeners).size() > 0) {
                    executor.execute(new Runnable(){

                        public void run() {
                            Object eventValue = value;
                            if (oldValue != null) {
                                eventValue = oldValue;
                            }
                            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)HazelSession.this, name, eventValue);
                            for (HttpSessionAttributeListener listener : lsSessionAttributeListeners) {
                                if (oldValue != null) {
                                    listener.attributeReplaced(event);
                                    continue;
                                }
                                listener.attributeAdded(event);
                            }
                        }
                    });
                }
            }
        }

        public void setKnownToCluster(boolean knownToCluster) {
            this.knownToCluster.set(knownToCluster);
        }

        public void setLastAccessed() {
            this.checkState();
            this.lastAccessedTime.set(System.currentTimeMillis());
        }

        public void setMaxInactiveInterval(int maxInactiveSeconds) {
            if (maxInactiveSeconds < 0) {
                maxInactiveSeconds = -1;
            }
            this.maxInactiveInterval.set((long)maxInactiveSeconds * 1000L);
        }

        public void setNew(boolean isNew) {
            this.isNew.set(isNew);
        }

        public synchronized Data writeObject(Object obj) {
            if (obj == null) {
                return null;
            }
            try {
                Data data = ThreadContext.get().toData(obj);
                int size = data.size();
                if (this.minSize == -1 || this.minSize > size) {
                    this.minSize = size;
                }
                if (this.maxSize == -1 || this.maxSize < size) {
                    this.maxSize = size;
                }
                return data;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        void destroy() {
            this.valid.set(false);
            this.context = null;
            this.atts.clear();
            this.md = null;
        }

        private void checkState() {
            if (!this.valid.get()) {
                throw new IllegalStateException("Session is invalid!");
            }
        }
    }

    private static class Controller
    implements Runnable {
        private Controller() {
        }

        public void control(AppContext app) {
            try {
                Collection sessions = app.mapSessions.values();
                long currentTime = System.currentTimeMillis();
                for (HazelSession session : sessions) {
                    if (session == null || !session.expired(currentTime) && session.valid.get()) continue;
                    String id = session.id;
                    app.destroySession(session);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void run() {
            for (AppContext appContext : mapApps.values()) {
                this.control(appContext);
            }
        }
    }

    private static class AppContext
    implements Context {
        protected static Logger logger = Logger.getLogger(AppContext.class.getName());
        List<ServletContextAttributeListener> lsContextAttListeners = new ArrayList<ServletContextAttributeListener>();
        List<HttpSessionListener> lsSessionListeners = new ArrayList<HttpSessionListener>();
        List<HttpSessionAttributeListener> lsSessionAttListeners = new ArrayList<HttpSessionAttributeListener>();
        List<ServletContextListener> lsContextListeners = new ArrayList<ServletContextListener>();
        List<ServletRequestListener> lsRequestListeners = new ArrayList<ServletRequestListener>();
        List<ServletRequestAttributeListener> lsRequestAttListeners = new ArrayList<ServletRequestAttributeListener>();
        List<SnapshotListener> lsSnapshotListeners = new ArrayList<SnapshotListener>();
        private final ConcurrentMap<String, HazelSession> mapSessions = new ConcurrentHashMap<String, HazelSession>(10);
        private final AtomicReference<Snapshot> snapshot = new AtomicReference();
        private int maxInactiveInterval = 1;
        private int snapshotLifeTime;
        private final ServletContext servletContext;
        private final AtomicBoolean ready = new AtomicBoolean(false);
        private final String clusterMapName;
        private final Queue<Runnable> scheduledContextEvents = new ConcurrentLinkedQueue<Runnable>();

        public AppContext(ServletContext servletContext) {
            this.servletContext = servletContext;
            this.clusterMapName = "_web_" + (appsSharingSessions ? "shared" : servletContext.getServletContextName());
            logger.log(Level.FINEST, "CLUSTER MAP NAME " + this.clusterMapName);
            this.servletContext.setAttribute("*hazelcast-servlet-context", (Object)this);
            this.init(1);
            this.snapshot.set(new Snapshot(this, this.snapshotLifeTime));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSnapshotListener(SnapshotListener snapshotListener) {
            List<SnapshotListener> list = this.lsSnapshotListeners;
            synchronized (list) {
                this.lsSnapshotListeners.add(snapshotListener);
            }
        }

        public void destroy() {
            this.mapSessions.clear();
        }

        public void fireAttributeAdded(final ServletContextAttributeEvent arg0) {
            if (this.ready.get()) {
                if (this.lsContextAttListeners.size() > 0) {
                    executor.execute(new Runnable(){

                        public void run() {
                            for (ServletContextAttributeListener listener : AppContext.this.lsContextAttListeners) {
                                listener.attributeAdded(arg0);
                            }
                        }
                    });
                }
            } else {
                this.scheduledContextEvents.add(new Runnable(){

                    public void run() {
                        AppContext.this.fireAttributeAdded(arg0);
                    }
                });
            }
        }

        public void fireAttributeRemoved(final ServletContextAttributeEvent arg0) {
            if (this.ready.get()) {
                if (this.lsContextAttListeners.size() > 0) {
                    executor.execute(new Runnable(){

                        public void run() {
                            for (ServletContextAttributeListener listener : AppContext.this.lsContextAttListeners) {
                                listener.attributeRemoved(arg0);
                            }
                        }
                    });
                }
            } else {
                this.scheduledContextEvents.add(new Runnable(){

                    public void run() {
                        AppContext.this.fireAttributeRemoved(arg0);
                    }
                });
            }
        }

        public void fireAttributeReplaced(final ServletContextAttributeEvent arg0) {
            if (this.ready.get()) {
                if (this.lsContextAttListeners.size() > 0) {
                    executor.execute(new Runnable(){

                        public void run() {
                            for (ServletContextAttributeListener listener : AppContext.this.lsContextAttListeners) {
                                listener.attributeReplaced(arg0);
                            }
                        }
                    });
                }
            } else {
                this.scheduledContextEvents.add(new Runnable(){

                    public void run() {
                        AppContext.this.fireAttributeReplaced(arg0);
                    }
                });
            }
        }

        public void fireContextDestroyed(final ServletContextEvent arg0) {
            if (this.ready.get() && this.lsContextListeners.size() > 0) {
                executor.execute(new Runnable(){

                    public void run() {
                        for (ServletContextListener listener : AppContext.this.lsContextListeners) {
                            listener.contextDestroyed(arg0);
                        }
                    }
                });
            }
        }

        public void fireContextInitilized(final ServletContextEvent arg0) {
            if (this.ready.get()) {
                if (this.lsContextListeners.size() > 0) {
                    executor.execute(new Runnable(){

                        public void run() {
                            for (ServletContextListener listener : AppContext.this.lsContextListeners) {
                                listener.contextInitialized(arg0);
                            }
                        }
                    });
                }
            } else {
                this.scheduledContextEvents.add(new Runnable(){

                    public void run() {
                        AppContext.this.fireContextInitilized(arg0);
                    }
                });
            }
        }

        public IMap getClusterMap() {
            return Hazelcast.getMap((String)this.clusterMapName);
        }

        public ServletContext getOriginalServletContext() {
            return this.servletContext;
        }

        public String getServletContextName() {
            return this.servletContext.getServletContextName();
        }

        public void init(int maxInactiveInterval) {
            this.maxInactiveInterval = maxInactiveInterval;
            this.snapshotLifeTime = maxInactiveInterval * 60 * 1000 / 30;
            if (maxInactiveInterval < 0) {
                this.snapshotLifeTime = 60000;
            } else if (maxInactiveInterval < 3) {
                this.snapshotLifeTime = 5000;
            } else if (maxInactiveInterval > 100) {
                this.snapshotLifeTime = 120000;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSnapshotListener(SnapshotListener snapshotListener) {
            List<SnapshotListener> list = this.lsSnapshotListeners;
            synchronized (list) {
                this.lsSnapshotListeners.remove(snapshotListener);
            }
        }

        public void setReady() {
            this.ready.set(true);
            if (this.scheduledContextEvents.size() > 0) {
                while (true) {
                    Runnable scheduled;
                    if ((scheduled = this.scheduledContextEvents.poll()) == null) {
                        return;
                    }
                    scheduled.run();
                }
            }
        }

        public boolean urlRewriteEnabled() {
            return true;
        }

        void changeSessionId(HazelSession session) {
            this.mapSessions.remove(session.getId());
            session.id = WebFilter.generateSessionId();
            while (this.mapSessions.containsKey(session.getId())) {
                session.id = WebFilter.generateSessionId();
            }
            this.mapSessions.put(session.getId(), session);
        }

        HazelSession createNewSession() {
            String id = WebFilter.generateSessionId();
            while (this.mapSessions.containsKey(id)) {
                id = WebFilter.generateSessionId();
            }
            return this.getSession(id, true);
        }

        void destroySession(final HazelSession session) {
            String id = session.id;
            if (this.lsSessionListeners.size() > 0) {
                executor.execute(new Runnable(){

                    public void run() {
                        HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                        for (HttpSessionListener listener : AppContext.this.lsSessionListeners) {
                            listener.sessionDestroyed(event);
                        }
                    }
                });
            }
            session.destroy();
            this.mapSessions.remove(id);
            this.getClusterMap().remove((Object)id);
            this.getSnapshot().destroyedSessions.incrementAndGet();
        }

        HazelSession getSession(String sessionId, boolean create) {
            HazelSession session = (HazelSession)this.mapSessions.get(sessionId);
            if (create && session == null) {
                session = new HazelSession(this, sessionId);
                session.setMaxInactiveInterval(this.maxInactiveInterval * 60);
                HazelSession oldSessionInfo = this.mapSessions.putIfAbsent(sessionId, session);
                if (oldSessionInfo != null) {
                    session = oldSessionInfo;
                }
            }
            return session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Snapshot getSnapshot() {
            Snapshot s = this.snapshot.get();
            if (!s.invalid()) return s;
            Class<Snapshot> clazz = Snapshot.class;
            synchronized (Snapshot.class) {
                s = this.snapshot.get();
                if (!s.invalid()) return s;
                Snapshot sNew = new Snapshot(this, this.snapshotLifeTime);
                boolean ok = this.snapshot.compareAndSet(s, sNew);
                if (!ok) return this.snapshot.get();
                this.fireSnapshotEvent(s.createSnapshotEvent());
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return sNew;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireSnapshotEvent(final SnapshotEvent snapshotEvent) {
            List<SnapshotListener> list = this.lsSnapshotListeners;
            synchronized (list) {
                for (final SnapshotListener listener : this.lsSnapshotListeners) {
                    executor.execute(new Runnable(){

                        public void run() {
                            listener.handleSnapshot(snapshotEvent);
                        }
                    });
                }
            }
        }
    }

    static class ResponseWrapper
    extends HttpServletResponseWrapper {
        AppContext context = null;
        RequestWrapper req = null;

        public ResponseWrapper(AppContext context, HttpServletResponse original) {
            super(original);
            this.context = context;
        }

        public String encodeURL(String url) {
            if (!this.context.urlRewriteEnabled()) {
                return url;
            }
            return this.encodeURL(url, WebFilter.SESSION_URL_PHRASE);
        }

        public String extractSessionId(String url) {
            int prefix = url.indexOf(WebFilter.SESSION_URL_PHRASE);
            if (prefix != -1) {
                int start = prefix + WebFilter.SESSION_URL_PHRASE.length();
                int suffix = url.indexOf("?", start);
                if (suffix < 0) {
                    suffix = url.indexOf("#", start);
                }
                if (suffix <= prefix) {
                    return url.substring(start);
                }
                return url.substring(start, suffix);
            }
            return null;
        }

        public RequestWrapper getRequest() {
            return this.req;
        }

        public void setRequest(RequestWrapper req) {
            this.req = req;
        }

        private String encodeURL(String url, String sessionURLPhrase) {
            if (url != null || this.req == null || this.req.isRequestedSessionIdFromCookie()) {
                int prefix = url.indexOf(sessionURLPhrase);
                if (prefix != -1) {
                    int suffix = url.indexOf("?", prefix);
                    if (suffix < 0) {
                        suffix = url.indexOf("#", prefix);
                    }
                    if (suffix <= prefix) {
                        return url.substring(0, prefix);
                    }
                    return url.substring(0, prefix) + url.substring(suffix);
                }
                return url;
            }
            HazelSession session = this.req.getSession(false);
            if (session == null) {
                return url;
            }
            if (!session.valid.get()) {
                return url;
            }
            String id = session.getId();
            int prefix = url.indexOf(sessionURLPhrase);
            if (prefix != -1) {
                int suffix = url.indexOf("?", prefix);
                if (suffix < 0) {
                    suffix = url.indexOf("#", prefix);
                }
                if (suffix <= prefix) {
                    return url.substring(0, prefix + sessionURLPhrase.length()) + id;
                }
                return url.substring(0, prefix + sessionURLPhrase.length()) + id + url.substring(suffix);
            }
            int suffix = url.indexOf(63);
            if (suffix < 0) {
                suffix = url.indexOf(35);
            }
            if (suffix < 0) {
                return url + sessionURLPhrase + id;
            }
            return url.substring(0, suffix) + sessionURLPhrase + id + url.substring(suffix);
        }
    }

    static class RequestWrapper
    extends HttpServletRequestWrapper {
        protected static Logger logger = Logger.getLogger(RequestWrapper.class.getName());
        HazelSession hazelSession = null;
        final ResponseWrapper res;
        final ConcurrentMap<String, Object> atts = new ConcurrentHashMap<String, Object>();
        final long creationTime;
        final AppContext context;
        final HttpServletRequest original;
        String requestedSessionId = null;
        boolean requestedSessionIdValid = true;
        boolean requestedSessionIdFromCookie = false;
        boolean requestedSessionIdFromURL = false;

        public RequestWrapper(AppContext context, HttpServletRequest req, ResponseWrapper res) {
            super(req);
            this.res = res;
            this.context = context;
            this.original = req;
            this.original.setAttribute(WebFilter.HAZELCAST_REQUEST, (Object)this);
            this.creationTime = System.nanoTime();
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equalsIgnoreCase("JSESSIONID")) continue;
                    this.requestedSessionId = cookie.getValue();
                    this.requestedSessionIdFromCookie = true;
                }
            }
            if (this.requestedSessionId == null) {
                this.requestedSessionId = res.extractSessionId(this.getRequestURL().toString());
                if (this.requestedSessionId != null) {
                    this.requestedSessionIdFromURL = true;
                }
            }
        }

        public Enumeration getAttributeNames() {
            if (this.atts.size() == 0) {
                return new IteratorEnumeration(null);
            }
            return new IteratorEnumeration(this.atts.keySet().iterator());
        }

        public RequestDispatcher getRequestDispatcher(String target) {
            return new RequestDispatcherWrapper(this.original.getRequestDispatcher(target), this.original);
        }

        public String getRequestedSessionId() {
            if (this.requestedSessionId != null) {
                return this.requestedSessionId;
            }
            return super.getRequestedSessionId();
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public HazelSession getSession(boolean create) {
            if (this.hazelSession != null) {
                return this.hazelSession;
            }
            String requestedSessionId = this.getRequestedSessionId();
            HazelSession session = null;
            if (requestedSessionId != null) {
                session = this.context.getSession(requestedSessionId, false);
            }
            if (session == null && create) {
                this.hazelSession = session = this.context.createNewSession();
                if (requestedSessionId != null) {
                    Map mapSession = (Map)this.context.getClusterMap().remove((Object)requestedSessionId);
                    if (mapSession != null) {
                        Set entries = mapSession.entrySet();
                        for (Map.Entry entry : entries) {
                            session.setAttribute((String)entry.getKey(), entry.getValue());
                        }
                    }
                    WebFilter.removeCookieForSession(this, requestedSessionId);
                    Cookie[] cookies = this.getCookies();
                    if (cookies != null) {
                        for (Cookie cookie : cookies) {
                            String name = cookie.getName();
                            String value = cookie.getValue();
                            String path = cookie.getPath();
                            if (!this.getContextPath().equals(path) || !name.equals("JSESSIONID") || !value.equals(requestedSessionId)) continue;
                            cookie.setMaxAge(0);
                            this.res.addCookie(cookie);
                            break;
                        }
                    }
                }
                WebFilter.addCookieForSession(this, session.getId());
            }
            return session;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return this.requestedSessionIdFromCookie;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return this.isRequestedSessionIdFromURL();
        }

        public boolean isRequestedSessionIdFromURL() {
            return this.requestedSessionIdFromURL;
        }

        public boolean isRequestedSessionIdValid() {
            return this.requestedSessionIdValid;
        }

        public Object getAttribute(String name) {
            return this.atts.get(name);
        }

        public void removeAttribute(final String name) {
            if (WebFilter.HAZELCAST_REQUEST.equals(name)) {
                return;
            }
            final Object oldValue = this.atts.remove(name);
            if (oldValue == null) {
                return;
            }
            if (this.context.lsRequestAttListeners.size() > 0) {
                executor.execute(new Runnable(){

                    public void run() {
                        ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(RequestWrapper.this.context.getOriginalServletContext(), (ServletRequest)RequestWrapper.this, name, oldValue);
                        for (ServletRequestAttributeListener listener : RequestWrapper.this.context.lsRequestAttListeners) {
                            listener.attributeRemoved(event);
                        }
                    }
                });
            }
        }

        public void setAttribute(final String name, final Object value) {
            if (WebFilter.HAZELCAST_REQUEST.equals(name)) {
                return;
            }
            if (value == null) {
                this.removeAttribute(name);
            } else {
                final Object oldValue = this.atts.put(name, value);
                if (this.context.lsRequestAttListeners.size() > 0) {
                    executor.execute(new Runnable(){

                        public void run() {
                            Object eventValue = oldValue == null ? value : oldValue;
                            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(RequestWrapper.this.context.getOriginalServletContext(), (ServletRequest)RequestWrapper.this, name, eventValue);
                            for (ServletRequestAttributeListener listener : RequestWrapper.this.context.lsRequestAttListeners) {
                                if (oldValue == null) {
                                    listener.attributeAdded(event);
                                    continue;
                                }
                                listener.attributeReplaced(event);
                            }
                        }
                    });
                }
            }
        }

        public void setRequestedSessionIdValid(boolean valid) {
            this.requestedSessionIdValid = valid;
        }

        class RequestDispatcherWrapper
        implements RequestDispatcher {
            final RequestDispatcher dispatcherOriginal;
            final HttpServletRequest reqOriginal;

            public RequestDispatcherWrapper(RequestDispatcher dispatcherOriginal, HttpServletRequest reqOriginal) {
                this.dispatcherOriginal = dispatcherOriginal;
                this.reqOriginal = reqOriginal;
            }

            public void forward(ServletRequest req, ServletResponse res) throws ServletException, IOException {
                this.dispatcherOriginal.forward((ServletRequest)this.reqOriginal, res);
            }

            public void include(ServletRequest req, ServletResponse res) throws ServletException, IOException {
                this.dispatcherOriginal.include((ServletRequest)this.reqOriginal, res);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IteratorEnumeration
    implements Enumeration<String> {
        Iterator<String> it = null;

        IteratorEnumeration(Iterator<String> it) {
            this.it = it;
        }

        @Override
        public boolean hasMoreElements() {
            return this.it != null && this.it.hasNext();
        }

        @Override
        public String nextElement() {
            if (this.it == null) {
                return null;
            }
            return this.it.next();
        }
    }

    public static class ContextListener
    implements ServletContextListener,
    ServletContextAttributeListener {
        public void attributeAdded(ServletContextAttributeEvent arg0) {
            if (arg0.getName().equals("*hazelcast-servlet-context")) {
                return;
            }
            AppContext app = WebFilter.ensureServletContext(arg0.getServletContext());
            if (app != null) {
                app.fireAttributeAdded(arg0);
            }
        }

        public void attributeRemoved(ServletContextAttributeEvent arg0) {
            if (arg0.getName().equals("*hazelcast-servlet-context")) {
                return;
            }
            AppContext app = WebFilter.ensureServletContext(arg0.getServletContext());
            if (app != null) {
                app.fireAttributeRemoved(arg0);
            }
        }

        public void attributeReplaced(ServletContextAttributeEvent arg0) {
            if (arg0.getName().equals("*hazelcast-servlet-context")) {
                return;
            }
            AppContext app = WebFilter.ensureServletContext(arg0.getServletContext());
            if (app != null) {
                app.fireAttributeReplaced(arg0);
            }
        }

        public void contextDestroyed(ServletContextEvent arg0) {
            AppContext app = WebFilter.getAppContext(arg0.getServletContext());
            if (app != null) {
                app.fireContextDestroyed(arg0);
            }
        }

        public void contextInitialized(ServletContextEvent arg0) {
            AppContext app = WebFilter.ensureServletContext(arg0.getServletContext());
            if (app != null) {
                app.fireContextInitilized(arg0);
            }
        }
    }
}

