/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.web.WebFilter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public class ServletBase
extends HttpServlet {
    protected static Logger logger = Logger.getLogger(ServletBase.class.getName());
    private static final boolean DEBUG = true;

    public void init(ServletConfig servletConfig) throws ServletException {
        WebFilter.ensureServletContext(servletConfig.getServletContext());
        super.init(servletConfig);
    }

    protected void debug(Object obj) {
        logger.log(Level.INFO, obj.toString());
    }

    class Config
    implements ServletConfig {
        ServletConfig original = null;
        ServletContext app = null;
        final Set<String> paramNames = new HashSet<String>();

        public Config(ServletConfig original) {
            this.original = original;
            Enumeration names = original.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.startsWith("*hazelcast")) continue;
                this.paramNames.add(name);
            }
        }

        public String getInitParameter(String arg0) {
            return this.original.getInitParameter(arg0);
        }

        public Enumeration getInitParameterNames() {
            final Iterator<String> it = this.paramNames.iterator();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return it.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)it.next();
                }
            };
        }

        public ServletContext getServletContext() {
            return this.getCurrentContext();
        }

        public String getServletName() {
            return this.original.getServletName();
        }

        private ServletContext getCurrentContext() {
            if (this.app == null) {
                this.app = WebFilter.getServletContext(this.original.getServletContext());
                if (this.app != null) {
                    return this.app;
                }
                return this.original.getServletContext();
            }
            return this.app;
        }
    }
}

