/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.nio;

import com.hazelcast.internal.tpcengine.Option;
import com.hazelcast.internal.tpcengine.net.AsyncSocketOptions;
import com.hazelcast.internal.tpcengine.util.OS;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ServerSocketChannel;
import java.util.Set;

public class NioAsyncServerSocketOptions
implements AsyncSocketOptions {
    private static final Set<SocketOption<?>> WINDOWS_UNSUPPORTED_OPTIONS = Set.of(StandardSocketOptions.SO_REUSEPORT);
    private final ServerSocketChannel serverSocketChannel;

    NioAsyncServerSocketOptions(ServerSocketChannel serverSocketChannel) {
        this.serverSocketChannel = serverSocketChannel;
    }

    private static SocketOption toSocketOption(Option option) {
        if (SO_RCVBUF.equals(option)) {
            return StandardSocketOptions.SO_RCVBUF;
        }
        if (SO_REUSEADDR.equals(option)) {
            return StandardSocketOptions.SO_REUSEADDR;
        }
        if (SO_REUSEPORT.equals(option)) {
            return StandardSocketOptions.SO_REUSEPORT;
        }
        return null;
    }

    @Override
    public boolean isSupported(Option option) {
        Preconditions.checkNotNull(option, "option");
        SocketOption socketOption = NioAsyncServerSocketOptions.toSocketOption(option);
        return this.isSupported(socketOption);
    }

    private boolean isSupported(SocketOption socketOption) {
        if (socketOption == null) {
            return false;
        }
        if (OS.isWindows() && WINDOWS_UNSUPPORTED_OPTIONS.contains(socketOption)) {
            return false;
        }
        return this.serverSocketChannel.supportedOptions().contains(socketOption);
    }

    @Override
    public <T> boolean set(Option<T> option, T value) {
        Preconditions.checkNotNull(option, "option");
        Preconditions.checkNotNull(value, "value");
        try {
            SocketOption socketOption = NioAsyncServerSocketOptions.toSocketOption(option);
            if (this.isSupported(socketOption)) {
                this.serverSocketChannel.setOption(socketOption, (Object)value);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to set " + option.name() + " with value [" + String.valueOf(value) + "]", e);
        }
    }

    @Override
    public <T> T get(Option<T> option) {
        Preconditions.checkNotNull(option, "option");
        try {
            SocketOption socketOption = NioAsyncServerSocketOptions.toSocketOption(option);
            if (this.isSupported(socketOption)) {
                return this.serverSocketChannel.getOption(socketOption);
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to get option " + option.name(), e);
        }
    }
}

