/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.math;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.UniExpressionWithType;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import com.hazelcast.sql.impl.type.converter.Converter;

public class AbsFunction<T>
extends UniExpressionWithType<T> {
    public AbsFunction() {
    }

    private AbsFunction(Expression<?> operand, QueryDataType resultType) {
        super(operand, resultType);
    }

    public static AbsFunction<?> create(Expression<?> operand, QueryDataType resultType) {
        return new AbsFunction(operand, resultType);
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        Object operandValue = this.operand.eval(row, context);
        if (operandValue == null) {
            return null;
        }
        return (T)AbsFunction.abs(operandValue, this.operand.getType(), this.resultType);
    }

    private static Object abs(Object operand, QueryDataType operandType, QueryDataType resultType) {
        Converter operandConverter = operandType.getConverter();
        switch (resultType.getTypeFamily()) {
            case TINYINT: {
                return (byte)Math.abs(operandConverter.asTinyint(operand));
            }
            case SMALLINT: {
                return (short)Math.abs(operandConverter.asSmallint(operand));
            }
            case INTEGER: {
                return Math.abs(operandConverter.asInt(operand));
            }
            case BIGINT: {
                long res = Math.abs(operandConverter.asBigint(operand));
                if (res < 0L) {
                    throw QueryException.error((int)2000, (String)"BIGINT overflow in ABS function (consider adding an explicit CAST to DECIMAL)");
                }
                return res;
            }
            case DECIMAL: {
                return operandConverter.asDecimal(operand).abs(QueryDataTypeUtils.DECIMAL_MATH_CONTEXT);
            }
            case REAL: {
                return Float.valueOf(Math.abs(operandConverter.asReal(operand)));
            }
            case DOUBLE: {
                return Math.abs(operandConverter.asDouble(operand));
            }
        }
        throw QueryException.error((String)("Unexpected result type: " + String.valueOf(resultType)));
    }

    public int getClassId() {
        return 51;
    }
}

