/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.client.Client;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.impl.NodeServiceProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class NodeServiceProviderImpl
implements NodeServiceProvider {
    private final NodeEngineImpl nodeEngine;

    public NodeServiceProviderImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public UUID getLocalMemberId() {
        return this.nodeEngine.getClusterService().getLocalMember().getUuid();
    }

    @Override
    public Collection<UUID> getDataMemberIds() {
        HashSet<UUID> res = new HashSet<UUID>();
        for (Member member : this.nodeEngine.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR)) {
            res.add(member.getUuid());
        }
        return res;
    }

    @Override
    public Set<UUID> getClientIds() {
        HashSet<UUID> res = new HashSet<UUID>();
        for (Client client : this.nodeEngine.getHazelcastInstance().getClientService().getConnectedClients()) {
            res.add(client.getUuid());
        }
        return res;
    }

    @Override
    public Connection getConnection(UUID memberId) {
        MemberImpl member = this.nodeEngine.getClusterService().getMember(memberId);
        if (member == null) {
            return null;
        }
        return this.nodeEngine.getNode().getServer().getConnectionManager(EndpointQualifier.MEMBER).getOrConnect(member.getAddress());
    }

    @Override
    public MapContainer getMap(String name) {
        MapService mapService = (MapService)this.nodeEngine.getService("hz:impl:mapService");
        return (MapContainer)mapService.getMapServiceContext().getMapContainers().get(name);
    }

    @Override
    public ILogger getLogger(Class<?> clazz) {
        return this.nodeEngine.getLogger(clazz);
    }
}

