/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.shape.fractal;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateList;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineSegment;
import com.hazelcast.shaded.org.locationtech.jts.math.Vector2D;
import com.hazelcast.shaded.org.locationtech.jts.shape.GeometricShapeBuilder;

public class KochSnowflakeBuilder
extends GeometricShapeBuilder {
    private CoordinateList coordList = new CoordinateList();
    private static final double HEIGHT_FACTOR = Math.sin(1.0471975511965976);
    private static final double ONE_THIRD = 0.3333333333333333;
    private static final double THIRD_HEIGHT = HEIGHT_FACTOR / 3.0;
    private static final double TWO_THIRDS = 0.6666666666666666;

    public KochSnowflakeBuilder(GeometryFactory geomFactory) {
        super(geomFactory);
    }

    public static int recursionLevelForSize(int numPts) {
        double pow4 = numPts / 3;
        double exp = Math.log(pow4) / Math.log(4.0);
        return (int)exp;
    }

    @Override
    public Geometry getGeometry() {
        int level = KochSnowflakeBuilder.recursionLevelForSize(this.numPts);
        LineSegment baseLine = this.getSquareBaseLine();
        Coordinate[] pts = this.getBoundary(level, baseLine.getCoordinate(0), baseLine.getLength());
        return this.geomFactory.createPolygon(this.geomFactory.createLinearRing(pts), null);
    }

    private Coordinate[] getBoundary(int level, Coordinate origin, double width) {
        double y = origin.y;
        if (level > 0) {
            y += THIRD_HEIGHT * width;
        }
        Coordinate p0 = new Coordinate(origin.x, y);
        Coordinate p1 = new Coordinate(origin.x + width / 2.0, y + width * HEIGHT_FACTOR);
        Coordinate p2 = new Coordinate(origin.x + width, y);
        this.addSide(level, p0, p1);
        this.addSide(level, p1, p2);
        this.addSide(level, p2, p0);
        this.coordList.closeRing();
        return this.coordList.toCoordinateArray();
    }

    public void addSide(int level, Coordinate p0, Coordinate p1) {
        if (level == 0) {
            this.addSegment(p0, p1);
        } else {
            Vector2D base = Vector2D.create(p0, p1);
            Coordinate midPt = base.multiply(0.5).translate(p0);
            Vector2D heightVec = base.multiply(THIRD_HEIGHT);
            Vector2D offsetVec = heightVec.rotateByQuarterCircle(1);
            Coordinate offsetPt = offsetVec.translate(midPt);
            int n2 = level - 1;
            Coordinate thirdPt = base.multiply(0.3333333333333333).translate(p0);
            Coordinate twoThirdPt = base.multiply(0.6666666666666666).translate(p0);
            this.addSide(n2, p0, thirdPt);
            this.addSide(n2, thirdPt, offsetPt);
            this.addSide(n2, offsetPt, twoThirdPt);
            this.addSide(n2, twoThirdPt, p1);
        }
    }

    private void addSegment(Coordinate p0, Coordinate p1) {
        this.coordList.add(p1);
    }
}

