/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.buffer;

public class BufferParameters {
    public static final int CAP_ROUND = 1;
    public static final int CAP_FLAT = 2;
    public static final int CAP_SQUARE = 3;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_MITRE = 2;
    public static final int JOIN_BEVEL = 3;
    public static final int DEFAULT_QUADRANT_SEGMENTS = 8;
    public static final double DEFAULT_MITRE_LIMIT = 5.0;
    public static final double DEFAULT_SIMPLIFY_FACTOR = 0.01;
    private int quadrantSegments = 8;
    private int endCapStyle = 1;
    private int joinStyle = 1;
    private double mitreLimit = 5.0;
    private boolean isSingleSided = false;
    private double simplifyFactor = 0.01;

    public BufferParameters() {
    }

    public BufferParameters(int quadrantSegments) {
        this.setQuadrantSegments(quadrantSegments);
    }

    public BufferParameters(int quadrantSegments, int endCapStyle) {
        this.setQuadrantSegments(quadrantSegments);
        this.setEndCapStyle(endCapStyle);
    }

    public BufferParameters(int quadrantSegments, int endCapStyle, int joinStyle, double mitreLimit) {
        this.setQuadrantSegments(quadrantSegments);
        this.setEndCapStyle(endCapStyle);
        this.setJoinStyle(joinStyle);
        this.setMitreLimit(mitreLimit);
    }

    public int getQuadrantSegments() {
        return this.quadrantSegments;
    }

    public void setQuadrantSegments(int quadSegs) {
        this.quadrantSegments = quadSegs;
    }

    public static double bufferDistanceError(int quadSegs) {
        double alpha = 1.5707963267948966 / (double)quadSegs;
        return 1.0 - Math.cos(alpha / 2.0);
    }

    public int getEndCapStyle() {
        return this.endCapStyle;
    }

    public void setEndCapStyle(int endCapStyle) {
        this.endCapStyle = endCapStyle;
    }

    public int getJoinStyle() {
        return this.joinStyle;
    }

    public void setJoinStyle(int joinStyle) {
        this.joinStyle = joinStyle;
    }

    public double getMitreLimit() {
        return this.mitreLimit;
    }

    public void setMitreLimit(double mitreLimit) {
        this.mitreLimit = mitreLimit;
    }

    public void setSingleSided(boolean isSingleSided) {
        this.isSingleSided = isSingleSided;
    }

    public boolean isSingleSided() {
        return this.isSingleSided;
    }

    public double getSimplifyFactor() {
        return this.simplifyFactor;
    }

    public void setSimplifyFactor(double simplifyFactor) {
        this.simplifyFactor = simplifyFactor < 0.0 ? 0.0 : simplifyFactor;
    }

    public BufferParameters copy() {
        BufferParameters bp = new BufferParameters();
        bp.quadrantSegments = this.quadrantSegments;
        bp.endCapStyle = this.endCapStyle;
        bp.joinStyle = this.joinStyle;
        bp.mitreLimit = this.mitreLimit;
        return bp;
    }
}

