/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.buffer;

import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.geom.TopologyException;
import com.hazelcast.shaded.org.locationtech.jts.math.MathUtil;
import com.hazelcast.shaded.org.locationtech.jts.noding.ScaledNoder;
import com.hazelcast.shaded.org.locationtech.jts.noding.snapround.SnapRoundingNoder;
import com.hazelcast.shaded.org.locationtech.jts.operation.buffer.BufferBuilder;
import com.hazelcast.shaded.org.locationtech.jts.operation.buffer.BufferParameters;
import java.util.ArrayList;
import java.util.List;

public class BufferOp {
    public static final int CAP_ROUND = 1;
    public static final int CAP_BUTT = 2;
    public static final int CAP_FLAT = 2;
    public static final int CAP_SQUARE = 3;
    private static int MAX_PRECISION_DIGITS = 12;
    private Geometry argGeom;
    private double distance;
    private BufferParameters bufParams = new BufferParameters();
    private Geometry resultGeometry = null;
    private RuntimeException saveException;
    private boolean isInvertOrientation = false;

    private static double precisionScaleFactor(Geometry g2, double distance, int maxPrecisionDigits) {
        Envelope env = g2.getEnvelopeInternal();
        double envMax = MathUtil.max(Math.abs(env.getMaxX()), Math.abs(env.getMaxY()), Math.abs(env.getMinX()), Math.abs(env.getMinY()));
        double expandByDistance = distance > 0.0 ? distance : 0.0;
        double bufEnvMax = envMax + 2.0 * expandByDistance;
        int bufEnvPrecisionDigits = (int)(Math.log(bufEnvMax) / Math.log(10.0) + 1.0);
        int minUnitLog10 = maxPrecisionDigits - bufEnvPrecisionDigits;
        double scaleFactor = Math.pow(10.0, minUnitLog10);
        return scaleFactor;
    }

    public static Geometry bufferOp(Geometry g2, double distance) {
        BufferOp gBuf = new BufferOp(g2);
        Geometry geomBuf = gBuf.getResultGeometry(distance);
        return geomBuf;
    }

    public static Geometry bufferOp(Geometry g2, double distance, BufferParameters params) {
        BufferOp bufOp = new BufferOp(g2, params);
        Geometry geomBuf = bufOp.getResultGeometry(distance);
        return geomBuf;
    }

    public static Geometry bufferOp(Geometry g2, double distance, int quadrantSegments) {
        BufferOp bufOp = new BufferOp(g2);
        bufOp.setQuadrantSegments(quadrantSegments);
        Geometry geomBuf = bufOp.getResultGeometry(distance);
        return geomBuf;
    }

    public static Geometry bufferOp(Geometry g2, double distance, int quadrantSegments, int endCapStyle) {
        BufferOp bufOp = new BufferOp(g2);
        bufOp.setQuadrantSegments(quadrantSegments);
        bufOp.setEndCapStyle(endCapStyle);
        Geometry geomBuf = bufOp.getResultGeometry(distance);
        return geomBuf;
    }

    public static Geometry bufferByZero(Geometry geom, boolean isBothOrientations) {
        Geometry buf0 = geom.buffer(0.0);
        if (!isBothOrientations) {
            return buf0;
        }
        BufferOp op = new BufferOp(geom);
        op.isInvertOrientation = true;
        Geometry buf0Inv = op.getResultGeometry(0.0);
        return BufferOp.combine(buf0, buf0Inv);
    }

    private static Geometry combine(Geometry poly0, Geometry poly1) {
        if (poly1.isEmpty()) {
            return poly0;
        }
        if (poly0.isEmpty()) {
            return poly1;
        }
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        BufferOp.extractPolygons(poly0, polys);
        BufferOp.extractPolygons(poly1, polys);
        if (polys.size() == 1) {
            return (Geometry)polys.get(0);
        }
        return poly0.getFactory().createMultiPolygon(GeometryFactory.toPolygonArray(polys));
    }

    private static void extractPolygons(Geometry poly0, List<Polygon> polys) {
        for (int i = 0; i < poly0.getNumGeometries(); ++i) {
            polys.add((Polygon)poly0.getGeometryN(i));
        }
    }

    public BufferOp(Geometry g2) {
        this.argGeom = g2;
    }

    public BufferOp(Geometry g2, BufferParameters bufParams) {
        this.argGeom = g2;
        this.bufParams = bufParams;
    }

    public void setEndCapStyle(int endCapStyle) {
        this.bufParams.setEndCapStyle(endCapStyle);
    }

    public void setQuadrantSegments(int quadrantSegments) {
        this.bufParams.setQuadrantSegments(quadrantSegments);
    }

    public Geometry getResultGeometry(double distance) {
        this.distance = distance;
        this.computeGeometry();
        return this.resultGeometry;
    }

    private void computeGeometry() {
        this.bufferOriginalPrecision();
        if (this.resultGeometry != null) {
            return;
        }
        PrecisionModel argPM = this.argGeom.getFactory().getPrecisionModel();
        if (argPM.getType() == PrecisionModel.FIXED) {
            this.bufferFixedPrecision(argPM);
        } else {
            this.bufferReducedPrecision();
        }
    }

    private void bufferReducedPrecision() {
        for (int precDigits = MAX_PRECISION_DIGITS; precDigits >= 0; --precDigits) {
            try {
                this.bufferReducedPrecision(precDigits);
            }
            catch (TopologyException ex) {
                this.saveException = ex;
            }
            if (this.resultGeometry == null) continue;
            return;
        }
        throw this.saveException;
    }

    private void bufferReducedPrecision(int precisionDigits) {
        double sizeBasedScaleFactor = BufferOp.precisionScaleFactor(this.argGeom, this.distance, precisionDigits);
        PrecisionModel fixedPM = new PrecisionModel(sizeBasedScaleFactor);
        this.bufferFixedPrecision(fixedPM);
    }

    private void bufferOriginalPrecision() {
        try {
            BufferBuilder bufBuilder = this.createBufferBullder();
            this.resultGeometry = bufBuilder.buffer(this.argGeom, this.distance);
        }
        catch (RuntimeException ex) {
            this.saveException = ex;
        }
    }

    private BufferBuilder createBufferBullder() {
        BufferBuilder bufBuilder = new BufferBuilder(this.bufParams);
        bufBuilder.setInvertOrientation(this.isInvertOrientation);
        return bufBuilder;
    }

    private void bufferFixedPrecision(PrecisionModel fixedPM) {
        SnapRoundingNoder snapNoder = new SnapRoundingNoder(new PrecisionModel(1.0));
        ScaledNoder noder = new ScaledNoder(snapNoder, fixedPM.getScale());
        BufferBuilder bufBuilder = this.createBufferBullder();
        bufBuilder.setWorkingPrecisionModel(fixedPM);
        bufBuilder.setNoder(noder);
        this.resultGeometry = bufBuilder.buffer(this.argGeom, this.distance);
    }
}

