/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.noding;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.util.Assert;

public class SegmentPointComparator {
    public static int compare(int octant, Coordinate p0, Coordinate p1) {
        if (p0.equals2D(p1)) {
            return 0;
        }
        int xSign = SegmentPointComparator.relativeSign(p0.x, p1.x);
        int ySign = SegmentPointComparator.relativeSign(p0.y, p1.y);
        switch (octant) {
            case 0: {
                return SegmentPointComparator.compareValue(xSign, ySign);
            }
            case 1: {
                return SegmentPointComparator.compareValue(ySign, xSign);
            }
            case 2: {
                return SegmentPointComparator.compareValue(ySign, -xSign);
            }
            case 3: {
                return SegmentPointComparator.compareValue(-xSign, ySign);
            }
            case 4: {
                return SegmentPointComparator.compareValue(-xSign, -ySign);
            }
            case 5: {
                return SegmentPointComparator.compareValue(-ySign, -xSign);
            }
            case 6: {
                return SegmentPointComparator.compareValue(-ySign, xSign);
            }
            case 7: {
                return SegmentPointComparator.compareValue(xSign, -ySign);
            }
        }
        Assert.shouldNeverReachHere("invalid octant value");
        return 0;
    }

    public static int relativeSign(double x0, double x1) {
        if (x0 < x1) {
            return -1;
        }
        if (x0 > x1) {
            return 1;
        }
        return 0;
    }

    private static int compareValue(int compareSign0, int compareSign1) {
        if (compareSign0 < 0) {
            return -1;
        }
        if (compareSign0 > 0) {
            return 1;
        }
        if (compareSign1 < 0) {
            return -1;
        }
        if (compareSign1 > 0) {
            return 1;
        }
        return 0;
    }
}

