/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.jsfr.json;

import com.hazelcast.shaded.org.jsfr.json.CollectAllListener;
import com.hazelcast.shaded.org.jsfr.json.CollectOneListener;
import com.hazelcast.shaded.org.jsfr.json.SurfingConfiguration;
import com.hazelcast.shaded.org.jsfr.json.ValueBox;
import com.hazelcast.shaded.org.jsfr.json.compiler.JsonPathCompiler;
import com.hazelcast.shaded.org.jsfr.json.path.JsonPath;
import com.hazelcast.shaded.org.jsfr.json.provider.JsonProvider;
import java.io.InputStream;
import java.util.Collection;

public class Collector {
    private SurfingConfiguration.Builder builder;
    private JsonProvider jsonProvider;
    private String jsonString;
    private InputStream jsonInputStream;

    Collector(SurfingConfiguration.Builder builder, JsonProvider jsonProvider, String jsonString, InputStream jsonInputStream) {
        this.builder = builder;
        this.jsonProvider = jsonProvider;
        this.jsonString = jsonString;
        this.jsonInputStream = jsonInputStream;
    }

    public <T> ValueBox<T> collectOne(JsonPath jsonPath, final Class<T> tClass) {
        final CollectOneListener listener = new CollectOneListener();
        this.builder.bind(jsonPath, listener);
        return new ValueBox<T>(){

            @Override
            public T get() {
                return Collector.this.jsonProvider.cast(listener.getValue(), tClass);
            }
        };
    }

    public <T> ValueBox<T> collectOne(String jsonPath, Class<T> tClass) {
        return this.collectOne(JsonPathCompiler.compile(jsonPath), tClass);
    }

    public ValueBox<Object> collectOne(String jsonPath) {
        return this.collectOne(jsonPath, Object.class);
    }

    public <T> ValueBox<Collection<T>> collectAll(JsonPath jsonPath, Class<T> tClass) {
        final CollectAllListener<T> listener = new CollectAllListener<T>(this.jsonProvider, tClass);
        this.builder.bind(jsonPath, listener);
        return new ValueBox<Collection<T>>(){

            @Override
            public Collection<T> get() {
                return listener.getCollection();
            }
        };
    }

    public <T> ValueBox<Collection<T>> collectAll(String jsonPath, Class<T> tClass) {
        return this.collectAll(JsonPathCompiler.compile(jsonPath), tClass);
    }

    public ValueBox<Collection<Object>> collectAll(String jsonPath) {
        return this.collectAll(jsonPath, Object.class);
    }

    public void exec() {
        if (this.jsonString != null) {
            this.builder.buildAndSurf(this.jsonString);
        } else if (this.jsonInputStream != null) {
            this.builder.buildAndSurf(this.jsonInputStream);
        }
    }
}

