/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.type;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Ord;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.type.AbstractSqlType;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;

abstract class ApplySqlType
extends AbstractSqlType {
    protected final ImmutableList<? extends RelDataType> types;

    ApplySqlType(SqlTypeName typeName, boolean isNullable, Iterable<? extends RelDataType> types) {
        super(typeName, isNullable, null);
        this.types = ImmutableList.copyOf(types);
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append((Object)this.typeName).append('<');
        Ord.forEach(this.types, (type, i) -> {
            if (i > 0) {
                sb.append(", ");
            }
            if (withDetail) {
                sb.append(type.getFullTypeString());
            } else {
                sb.append(type.toString());
            }
        });
        sb.append('>');
    }
}

