/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.fun;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.DataContext;
import com.hazelcast.shaded.org.apache.calcite.config.CalciteConnectionConfig;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Linq4j;
import com.hazelcast.shaded.org.apache.calcite.linq4j.function.Functions;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.runtime.SpatialTypeFunctions;
import com.hazelcast.shaded.org.apache.calcite.schema.ScannableTable;
import com.hazelcast.shaded.org.apache.calcite.schema.Schema;
import com.hazelcast.shaded.org.apache.calcite.schema.Statistic;
import com.hazelcast.shaded.org.apache.calcite.schema.Statistics;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import java.math.BigDecimal;

public class SqlSpatialTypeFunctions {
    private SqlSpatialTypeFunctions() {
    }

    public static ScannableTable ST_Explode(Geometry geom) {
        return new ExplodeTable(geom);
    }

    public static ScannableTable ST_MakeGrid(Geometry geom, BigDecimal deltaX, BigDecimal deltaY) {
        return new GridTable(geom, deltaX, deltaY, false);
    }

    public static ScannableTable ST_MakeGridPoints(Geometry geom, BigDecimal deltaX, BigDecimal deltaY) {
        return new GridTable(geom, deltaX, deltaY, true);
    }

    public static class GridTable
    implements ScannableTable {
        private final Geometry geom;
        private final BigDecimal deltaX;
        private final BigDecimal deltaY;
        private boolean point;

        GridTable(Geometry geom, BigDecimal deltaX, BigDecimal deltaY, boolean point) {
            this.geom = geom;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.point = point;
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("THE_GEOM", SqlTypeName.GEOMETRY).add("ID", SqlTypeName.INTEGER).add("ID_COL", SqlTypeName.INTEGER).add("ID_ROW", SqlTypeName.INTEGER).add("ABS_COL", SqlTypeName.INTEGER).add("ABS_ROW", SqlTypeName.INTEGER).build();
        }

        @Override
        public Enumerable<@Nullable Object[]> scan(DataContext root) {
            if (this.geom != null && this.deltaX != null && this.deltaY != null && this.deltaX.compareTo(BigDecimal.ZERO) > 0 && this.deltaY.compareTo(BigDecimal.ZERO) > 0) {
                return new SpatialTypeFunctions.GridEnumerable(this.geom.getEnvelopeInternal(), this.deltaX, this.deltaY, this.point);
            }
            return Linq4j.emptyEnumerable();
        }

        @Override
        public Statistic getStatistic() {
            return Statistics.of(100.0, ImmutableList.of(ImmutableBitSet.of(0, 1)));
        }

        @Override
        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.OTHER;
        }

        @Override
        public boolean isRolledUp(String column) {
            return false;
        }

        @Override
        public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, @Nullable SqlNode parent, @Nullable CalciteConnectionConfig config) {
            return false;
        }
    }

    public static class ExplodeTable
    implements ScannableTable {
        private final Geometry geometry;

        public ExplodeTable(Geometry geometry) {
            this.geometry = geometry;
        }

        @Override
        public Enumerable<@Nullable Object[]> scan(DataContext root) {
            return Linq4j.asEnumerable(Functions.generate(this.geometry.getNumGeometries(), i -> new Object[]{this.geometry.getGeometryN(i), i}));
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("GEOM", SqlTypeName.GEOMETRY).add("INDEX", SqlTypeName.INTEGER).build();
        }

        @Override
        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        @Override
        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.TABLE;
        }

        @Override
        public boolean isRolledUp(String column) {
            return false;
        }

        @Override
        public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, @Nullable SqlNode parent, @Nullable CalciteConnectionConfig config) {
            return true;
        }
    }
}

