/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.rules;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.shaded.org.apache.calcite.rel.core.AggregateCall;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Values;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.ImmutableAggregateValuesRule;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.SubstitutionRule;
import com.hazelcast.shaded.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.shaded.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.immutables.value.Value;

@Value.Enclosing
public class AggregateValuesRule
extends RelRule<Config>
implements SubstitutionRule {
    protected AggregateValuesRule(Config config) {
        super(config);
    }

    @Deprecated
    public AggregateValuesRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Values values = (Values)call.rel(1);
        Util.discard(values);
        RelBuilder relBuilder = call.builder();
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        ArrayList<RexLiteral> literals = new ArrayList<RexLiteral>();
        block4: for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            switch (aggregateCall.getAggregation().getKind()) {
                case COUNT: 
                case SUM0: {
                    literals.add(rexBuilder.makeLiteral(BigDecimal.ZERO, aggregateCall.getType()));
                    continue block4;
                }
                case MIN: 
                case MAX: 
                case SUM: {
                    literals.add(rexBuilder.makeNullLiteral(aggregateCall.getType()));
                    continue block4;
                }
            }
            return;
        }
        call.transformTo(relBuilder.values(ImmutableList.of(literals), aggregate.getRowType()).build());
        call.getPlanner().prune(aggregate);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableAggregateValuesRule.Config.of().withOperandFor(Aggregate.class, Values.class);

        @Override
        default public AggregateValuesRule toRule() {
            return new AggregateValuesRule(this);
        }

        default public Config withOperandFor(Class<? extends Aggregate> aggregateClass, Class<? extends Values> valuesClass) {
            return this.withOperandSupplier(b0 -> b0.operand(aggregateClass).predicate(aggregate -> aggregate.getGroupCount() == 0).oneInput(b1 -> b1.operand(valuesClass).predicate(values -> values.getTuples().isEmpty()).noInputs())).as(Config.class);
        }
    }
}

