/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.core;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelWriter;
import com.hazelcast.shaded.org.apache.calcite.rel.SingleRel;
import com.hazelcast.shaded.org.apache.calcite.rel.hint.Hintable;
import com.hazelcast.shaded.org.apache.calcite.rel.hint.RelHint;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMdUtil;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLocalRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexOver;
import com.hazelcast.shaded.org.apache.calcite.rex.RexProgram;
import com.hazelcast.shaded.org.apache.calcite.rex.RexProgramBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.shaded.org.apache.calcite.rex.RexUtil;
import com.hazelcast.shaded.org.apache.calcite.util.Litmus;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public abstract class Calc
extends SingleRel
implements Hintable {
    protected final ImmutableList<RelHint> hints;
    protected final RexProgram program;

    protected Calc(RelOptCluster cluster, RelTraitSet traits, List<RelHint> hints, RelNode child, RexProgram program) {
        super(cluster, traits, child);
        this.rowType = program.getOutputRowType();
        this.program = program;
        this.hints = ImmutableList.copyOf(hints);
        assert (this.isValid(Litmus.THROW, null));
    }

    @Deprecated
    protected Calc(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexProgram program) {
        this(cluster, traits, ImmutableList.of(), child, program);
    }

    @Deprecated
    protected Calc(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexProgram program, List<RelCollation> collationList) {
        this(cluster, traits, ImmutableList.of(), child, program);
        Util.discard(collationList);
    }

    @Override
    public final Calc copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Calc.sole(inputs), this.program);
    }

    public abstract Calc copy(RelTraitSet var1, RelNode var2, RexProgram var3);

    @Deprecated
    public Calc copy(RelTraitSet traitSet, RelNode child, RexProgram program, List<RelCollation> collationList) {
        Util.discard(collationList);
        return this.copy(traitSet, child, program);
    }

    public final boolean containsOver() {
        return RexOver.containsOver(this.program);
    }

    @Override
    public boolean isValid(Litmus litmus, @Nullable RelNode.Context context) {
        if (!RelOptUtil.equal("program's input type", this.program.getInputRowType(), "child's output type", this.getInput().getRowType(), litmus)) {
            return litmus.fail(null, new Object[0]);
        }
        if (!this.program.isValid(litmus, context)) {
            return litmus.fail(null, new Object[0]);
        }
        if (!this.program.isNormalized(litmus, this.getCluster().getRexBuilder())) {
            return litmus.fail(null, new Object[0]);
        }
        return litmus.succeed();
    }

    public RexProgram getProgram() {
        return this.program;
    }

    @Override
    public ImmutableList<RelHint> getHints() {
        return this.hints;
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return RelMdUtil.estimateFilteredRows(this.getInput(), this.program, mq);
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = mq.getRowCount(this);
        double dCpu = mq.getRowCount(this.getInput()) * (double)this.program.getExprCount();
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return this.program.explainCalc(super.explainTerms(pw));
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        RexNode condition;
        List<RexNode> oldExprs = this.program.getExprList();
        List<RexNode> exprs = shuttle.apply(oldExprs);
        List<RexLocalRef> oldProjects = this.program.getProjectList();
        List<RexLocalRef> projects = shuttle.apply(oldProjects);
        RexLocalRef oldCondition = this.program.getCondition();
        if (oldCondition != null) {
            condition = shuttle.apply(oldCondition);
            assert (condition instanceof RexLocalRef) : "Invalid condition after rewrite. Expected RexLocalRef, got " + condition;
        } else {
            condition = null;
        }
        if (exprs == oldExprs && projects == oldProjects && condition == oldCondition) {
            return this;
        }
        RexBuilder rexBuilder = this.getCluster().getRexBuilder();
        RelDataType rowType = RexUtil.createStructType(rexBuilder.getTypeFactory(), projects, this.getRowType().getFieldNames(), null);
        RexProgram newProgram = RexProgramBuilder.create(rexBuilder, this.program.getInputRowType(), exprs, projects, condition, rowType, true, null).getProgram(false);
        return this.copy(this.traitSet, this.getInput(), newProgram);
    }
}

