/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate;

import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;

public final class ValidationUtil {
    private ValidationUtil() {
    }

    public static boolean hasAssignment(SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            if (operand == null || operand.getKind() != SqlKind.ARGUMENT_ASSIGNMENT) continue;
            return true;
        }
        return false;
    }

    public static SqlNode unwrapFunctionOperand(SqlNode operand) {
        return operand.getKind() == SqlKind.ARGUMENT_ASSIGNMENT ? ((SqlCall)operand).operand(0) : operand;
    }

    public static RexNode unwrapAsOperatorOperand(RexNode operand) {
        return operand.getKind() == SqlKind.AS ? ((RexCall)operand).getOperands().get(0) : operand;
    }

    public static boolean isCatalogObjectNameValid(SqlIdentifier name) {
        return name.names.size() == 1 || name.names.size() == 2 && "public".equals(name.names.get(0)) || name.names.size() == 3 && "hazelcast".equals(name.names.get(0)) && "public".equals(name.names.get(1));
    }
}

