/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.JoinLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.ImmutableJoinValidationRule;
import com.hazelcast.jet.sql.impl.opt.physical.MustNotExecutePhysicalRel;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.TransformationRule;
import org.immutables.value.Value;

@Value.Enclosing
public final class JoinValidationRule
extends RelRule<RelRule.Config>
implements TransformationRule {
    public static final RelOptRule INSTANCE = new JoinValidationRule(Config.DEFAULT);

    private JoinValidationRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        JoinLogicalRel join = (JoinLogicalRel)call.rel(0);
        boolean rightInputIsStream = OptUtils.isUnbounded(join.getRight());
        if (rightInputIsStream && OptUtils.isUnbounded(join.getLeft())) {
            return;
        }
        if (join.getJoinType() == JoinRelType.LEFT) {
            if (rightInputIsStream) {
                call.transformTo(new MustNotExecutePhysicalRel(join.getCluster(), OptUtils.toPhysicalConvention(join.getTraitSet()), join.getRowType(), "The right side of a LEFT JOIN or the left side of RIGHT JOIN cannot be a streaming source"));
            }
        } else if (join.getJoinType() == JoinRelType.INNER && rightInputIsStream) {
            call.transformTo(new MustNotExecutePhysicalRel(join.getCluster(), OptUtils.toPhysicalConvention(join.getTraitSet()), join.getRowType(), "The right side of an INNER JOIN cannot be a streaming source"));
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableJoinValidationRule.Config.builder().description(JoinValidationRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(JoinLogicalRel.class).anyInputs()).build();

        @Override
        default public RelOptRule toRule() {
            return new JoinValidationRule(this);
        }
    }
}

