/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.metadata;

import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.metadata.HazelcastRelMetadataQuery;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.IndexScanMapPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.prunability.PartitionStrategyConditionExtractor;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Types;
import com.hazelcast.shaded.org.apache.calcite.plan.volcano.RelSubset;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Calc;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Join;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Sort;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Union;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.Metadata;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.MetadataDef;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.MetadataHandler;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class HazelcastRelMdPrunability
implements MetadataHandler<PrunabilityMetadata> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(PrunabilityMetadata.METHOD, new HazelcastRelMdPrunability());

    private HazelcastRelMdPrunability() {
    }

    @Override
    public MetadataDef<PrunabilityMetadata> getDef() {
        return PrunabilityMetadata.DEF;
    }

    public Map<String, List<Map<String, RexNode>>> extractPrunability(FullScanPhysicalRel scan, RelMetadataQuery mq) {
        Set<String> partitioningColumns;
        HazelcastTable hazelcastTable = OptUtils.extractHazelcastTable(scan);
        if (!(hazelcastTable.getTarget() instanceof PartitionedMapTable)) {
            return Collections.emptyMap();
        }
        PartitionedMapTable targetTable = (PartitionedMapTable)hazelcastTable.getTarget();
        if (!targetTable.supportsPartitionPruning()) {
            return Collections.emptyMap();
        }
        if (targetTable.partitioningAttributes().isEmpty()) {
            partitioningColumns = Set.of(QueryPath.KEY);
        } else {
            HashSet<String> partitioningFieldNames = new HashSet<String>(targetTable.partitioningAttributes());
            partitioningColumns = targetTable.keyFields().filter(kf -> partitioningFieldNames.contains(kf.getPath().getPath())).map(TableField::getName).collect(Collectors.toSet());
        }
        RexNode filter = hazelcastTable.getFilter();
        if (!(filter instanceof RexCall)) {
            return Collections.emptyMap();
        }
        RexCall call = (RexCall)filter;
        PartitionStrategyConditionExtractor conditionExtractor = new PartitionStrategyConditionExtractor();
        return conditionExtractor.extractCondition(targetTable, call, partitioningColumns);
    }

    public Map<String, List<Map<String, RexNode>>> extractPrunability(IndexScanMapPhysicalRel scan, RelMetadataQuery mq) {
        return Collections.emptyMap();
    }

    public Map<String, List<Map<String, RexNode>>> extractPrunability(Calc calc, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        return query.extractPrunability(calc.getInput());
    }

    public Map<String, List<Map<String, RexNode>>> extractPrunability(Aggregate agg, RelMetadataQuery mq) {
        return Collections.emptyMap();
    }

    public Map<String, List<Map<String, RexNode>>> extractPrunability(RelSubset subset, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        RelNode rel = Util.first(subset.getBest(), subset.getOriginal());
        return query.extractPrunability(rel);
    }

    public Map<String, List<Map<String, RexNode>>> extractPrunability(Join rel, RelMetadataQuery mq) {
        return Collections.emptyMap();
    }

    public Map<String, List<Map<String, RexNode>>> extractPrunability(Union rel, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        HashMap<String, List<Map<String, RexNode>>> prunability = new HashMap<String, List<Map<String, RexNode>>>();
        for (int i = 0; i < rel.getInputs().size(); ++i) {
            RelNode input = rel.getInput(i);
            Map<String, List<Map<String, RexNode>>> extractedPrunability = query.extractPrunability(input);
            if (extractedPrunability.isEmpty()) {
                return Collections.emptyMap();
            }
            for (String tableName : extractedPrunability.keySet()) {
                List<Map<String, RexNode>> tableVariants = extractedPrunability.get(tableName);
                prunability.putIfAbsent(tableName, new ArrayList());
                ((List)prunability.get(tableName)).addAll(tableVariants);
            }
        }
        return prunability;
    }

    public Map<String, List<Map<String, RexNode>>> extractPrunability(Sort rel, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        return query.extractPrunability(rel.getInput());
    }

    public Map<String, List<Map<String, RexNode>>> extractPrunability(RelNode rel, RelMetadataQuery mq) {
        return Collections.emptyMap();
    }

    public static interface PrunabilityMetadata
    extends Metadata {
        public static final Method METHOD = Types.lookupMethod(PrunabilityMetadata.class, "extractPrunability", new Class[0]);
        public static final MetadataDef<PrunabilityMetadata> DEF = MetadataDef.of(PrunabilityMetadata.class, Handler.class, METHOD);

        public List<Map<String, RexNode>> extractPrunability();

        public static interface Handler
        extends MetadataHandler<PrunabilityMetadata> {
            public Map<String, List<Map<String, RexNode>>> extractPrunability(RelNode var1, RelMetadataQuery var2);
        }
    }
}

