/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.virtual;

import com.hazelcast.jet.sql.impl.OptimizerContext;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ViewTable
extends Table {
    private final String viewQuery;
    private RelNode viewRel;

    public ViewTable(String schemaName, String viewName, String viewQuery, TableStatistics statistics) {
        super(schemaName, viewName, null, statistics, "View", false);
        this.viewQuery = viewQuery;
    }

    @Override
    public PlanObjectKey getObjectKey() {
        return new ViewPlanObjectKey(this.getSchemaName(), this.getSqlName(), this.viewQuery, this.getConflictingSchemas());
    }

    @Override
    protected List<TableField> initFields() {
        String viewPath;
        OptimizerContext context = OptimizerContext.getThreadContext();
        Deque<String> expansionStack = context.getViewExpansionStack();
        if (expansionStack.contains(viewPath = this.getSchemaName() + "." + this.getSqlName())) {
            throw QueryException.error((String)"Cycle detected in view references");
        }
        expansionStack.push(viewPath);
        SqlNode sqlNode = context.parse(this.viewQuery).getNode();
        this.viewRel = context.convertView(sqlNode);
        expansionStack.pop();
        List<RelDataTypeField> fieldList = this.viewRel.getRowType().getFieldList();
        ArrayList<TableField> res = new ArrayList<TableField>(fieldList.size());
        for (RelDataTypeField f : fieldList) {
            res.add(new TableField(f.getName(), HazelcastTypeUtils.toHazelcastType(f.getType()), false));
        }
        context.getUsedViews().add(this.getObjectKey());
        this.streaming = OptUtils.isUnbounded(this.viewRel);
        return res;
    }

    public RelNode getViewRel() {
        this.getFields();
        assert (this.viewRel != null);
        return this.viewRel;
    }

    @Override
    public boolean isStreaming() {
        this.getFields();
        return super.isStreaming();
    }

    static class ViewPlanObjectKey
    implements PlanObjectKey {
        private final String schemaName;
        private final String viewName;
        private final String query;
        private final Set<String> conflictingSchemas;

        ViewPlanObjectKey(String schemaName, String viewName, String query, Set<String> conflictingSchemas) {
            this.schemaName = schemaName;
            this.viewName = viewName;
            this.query = query;
            this.conflictingSchemas = conflictingSchemas;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ViewPlanObjectKey that = (ViewPlanObjectKey)o;
            return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.viewName, that.viewName) && Objects.equals(this.query, that.query) && Objects.equals(this.conflictingSchemas, that.conflictingSchemas);
        }

        public int hashCode() {
            return Objects.hash(this.schemaName, this.viewName, this.query, this.conflictingSchemas);
        }
    }
}

