/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.processor.AsyncTransformUsingServiceBatchedP;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.ServiceFactories;
import com.hazelcast.jet.sql.impl.connector.map.UpdatingEntryProcessor;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.security.impl.function.SecuredFunctions;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.UntrustedExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

final class UpdateProcessorSupplier
implements ProcessorSupplier,
DataSerializable {
    private static final int MAX_CONCURRENT_OPS = 8;
    private static final int MAX_BATCH_SIZE = 1024;
    private String mapName;
    private UpdatingEntryProcessor.Supplier updaterSupplier;
    private transient ExpressionEvalContext evalContext;

    private UpdateProcessorSupplier() {
    }

    UpdateProcessorSupplier(String mapName, UpdatingEntryProcessor.Supplier updaterSupplier) {
        this.mapName = mapName;
        this.updaterSupplier = updaterSupplier;
    }

    public void init(@Nonnull ProcessorSupplier.Context context) {
        this.evalContext = ExpressionEvalContext.from((ProcessorMetaSupplier.Context)context).withSerializationService(Util.getSerializationService((HazelcastInstance)context.hazelcastInstance()));
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList<AsyncTransformUsingServiceBatchedP> processors = new ArrayList<AsyncTransformUsingServiceBatchedP>(count);
        for (int i = 0; i < count; ++i) {
            String mapName = this.mapName;
            AsyncTransformUsingServiceBatchedP processor = new AsyncTransformUsingServiceBatchedP(ServiceFactories.nonSharedService((FunctionEx)SecuredFunctions.iMapFn((String)mapName)), null, 8, 1024, (BiFunctionEx & Serializable)(map, rows) -> this.update((List<JetSqlRow>)rows, (IMap<Object, Object>)map));
            processors.add(processor);
        }
        return processors;
    }

    private CompletableFuture<Traverser<Integer>> update(List<JetSqlRow> rows, IMap<Object, Object> map) {
        HashSet<Object> keys = new HashSet<Object>();
        for (JetSqlRow row : rows) {
            assert (row.getFieldCount() == 1);
            keys.add(row.get(0));
        }
        return map.submitToKeys(keys, this.updaterSupplier.get(UntrustedExpressionEvalContext.from(this.evalContext))).toCompletableFuture().thenApply(m4 -> Traversers.empty());
    }

    public List<Permission> permissions() {
        return Collections.singletonList(new MapPermission(this.mapName, new String[]{"create", "put"}));
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.mapName);
        out.writeObject((Object)this.updaterSupplier);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.mapName = in.readString();
        this.updaterSupplier = (UpdatingEntryProcessor.Supplier)in.readObject();
    }
}

