/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.ParamCollectingVisitor;
import com.hazelcast.shaded.com.google.common.primitives.Ints;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class UpdateQueryBuilder
extends AbstractQueryBuilder {
    private final List<Integer> dynamicParams = new ArrayList<Integer>();
    private final List<Integer> inputRefs = new ArrayList<Integer>();

    UpdateQueryBuilder(JdbcTable table, SqlDialect dialect, List<String> fieldNames, List<RexNode> expressions, RexNode predicate, boolean hasInput) {
        super(table, dialect);
        assert (fieldNames.size() == expressions.size());
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        dialect.quoteIdentifier(sb, Arrays.asList(table.getExternalName()));
        sb.append(" SET ");
        ParamCollectingVisitor dynamicParamVisitor = new ParamCollectingVisitor(this.dynamicParams);
        for (int i = 0; i < fieldNames.size(); ++i) {
            RexNode rexNode = expressions.get(i);
            SqlNode sqlNode = this.context.toSql(null, rexNode);
            sqlNode.accept(dynamicParamVisitor);
            String externalFieldName = table.getField(fieldNames.get(i)).externalName();
            dialect.quoteIdentifier(sb, externalFieldName);
            sb.append('=');
            sb.append(sqlNode.toSqlString(dialect).toString());
            if (i >= fieldNames.size() - 1) continue;
            sb.append(", ");
        }
        if (predicate != null) {
            this.appendPredicate(sb, predicate, this.dynamicParams);
        } else if (hasInput) {
            this.appendPrimaryKeyPredicate(sb, this.inputRefs);
        }
        this.query = sb.toString();
    }

    int[] dynamicParams() {
        return Ints.toArray(this.dynamicParams);
    }

    int[] inputRefs() {
        return Ints.toArray(this.inputRefs);
    }
}

