/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTableField;
import com.hazelcast.jet.sql.impl.connector.jdbc.NodeToSqlTranslationContext;
import com.hazelcast.jet.sql.impl.connector.jdbc.ParamCollectingVisitor;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import java.util.Iterator;
import java.util.List;

public class AbstractQueryBuilder {
    protected final JdbcTable jdbcTable;
    protected final SqlDialect dialect;
    protected final NodeToSqlTranslationContext context;
    protected String query;

    public AbstractQueryBuilder(JdbcTable jdbcTable, SqlDialect dialect) {
        this.jdbcTable = jdbcTable;
        this.dialect = dialect;
        this.context = new NodeToSqlTranslationContext(dialect, value -> {
            JdbcTableField field = (JdbcTableField)jdbcTable.getField(value);
            return new SqlIdentifier(field.externalName(), SqlParserPos.ZERO);
        });
    }

    protected void appendFieldNames(StringBuilder sb, List<String> fieldNames) {
        sb.append('(');
        Iterator<String> it = fieldNames.iterator();
        while (it.hasNext()) {
            String fieldName = it.next();
            this.dialect.quoteIdentifier(sb, fieldName);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append(')');
    }

    protected void appendValues(StringBuilder sb, int count) {
        sb.append('(');
        for (int i = 0; i < count; ++i) {
            sb.append('?');
            if (i >= count - 1) continue;
            sb.append(',');
        }
        sb.append(')');
    }

    protected void appendPredicate(StringBuilder sb, RexNode predicate, List<Integer> parameterPositions) {
        SqlNode sqlNode = this.context.toSql(null, predicate);
        sqlNode.accept(new ParamCollectingVisitor(parameterPositions));
        String predicateFragment = sqlNode.toSqlString(this.dialect).toString();
        sb.append(" WHERE ").append(predicateFragment);
    }

    protected void appendPrimaryKeyPredicate(StringBuilder sb, List<Integer> parameterPositions) {
        sb.append(" WHERE ");
        List<String> pkFields = this.jdbcTable.getPrimaryKeyList();
        for (int i = 0; i < pkFields.size(); ++i) {
            String field = pkFields.get(i);
            String externalFieldName = this.jdbcTable.getField(field).externalName();
            sb.append(this.dialect.quoteIdentifier(externalFieldName)).append("=?");
            if (i < pkFields.size() - 1) {
                sb.append(" AND ");
            }
            parameterPositions.add(i);
        }
    }

    public String query() {
        return this.query;
    }
}

