/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.precision;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.SineStarFactory;
import com.hazelcast.shaded.org.locationtech.jts.precision.GeometryPrecisionReducer;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;

public class GeometryPrecisionReducerPerfTest
extends PerformanceTestCase {
    private static final int N_ITER = 1;
    static double ORG_X = 100.0;
    static double ORG_Y = 100.0;
    static double SIZE = 100.0;
    static int N_ARMS = 20;
    static double ARM_RATIO = 0.3;
    private Geometry sineStar;
    private PrecisionModel pm;
    private int iter = 0;

    public static void main(String[] args) {
        PerformanceTestRunner.run(GeometryPrecisionReducerPerfTest.class);
    }

    public GeometryPrecisionReducerPerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{100, 200, 400, 1000, 2000, 4000, 8000, 10000, 100000, 200000, 400000, 1000000, 2000000});
        this.setRunIterations(1);
    }

    @Override
    public void setUp() {
        System.out.println("Geometry Precision Reducer perf test");
        System.out.println("SineStar: origin: (" + ORG_X + ", " + ORG_Y + ")  size: " + SIZE + "  # arms: " + N_ARMS + "  arm ratio: " + ARM_RATIO);
        System.out.println("# Iterations: 1");
    }

    @Override
    public void startRun(int npts) {
        this.iter = 0;
        this.sineStar = SineStarFactory.create((Coordinate)new Coordinate(ORG_X, ORG_Y), (double)SIZE, (int)npts, (int)N_ARMS, (double)ARM_RATIO);
        double scale = (double)npts / SIZE;
        this.pm = new PrecisionModel(scale);
        System.out.format("\n# pts = %d, Scale = %f\n", npts, scale);
        if (npts <= 1000) {
            System.out.println(this.sineStar);
        }
    }

    public void runReduce() {
        Geometry sinePolyCrinkly = GeometryPrecisionReducer.reduce((Geometry)this.sineStar, (PrecisionModel)this.pm);
    }
}

