/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.valid;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import test.jts.geom.TestShapeFactory;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;

public class IsValidNestedHolesPerfTest
extends PerformanceTestCase {
    static final int N_ITER = 10;
    Geometry geom;
    static int NUM_GEOMS = 100;

    public static void main(String[] args) {
        PerformanceTestRunner.run(IsValidNestedHolesPerfTest.class);
    }

    public IsValidNestedHolesPerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{1000, 10000, 100000, 1000000, 2000000});
        this.setRunIterations(10);
    }

    @Override
    public void startRun(int npts) {
        this.geom = this.createSlantHoles(npts);
    }

    private Geometry createSlantHoles(int npts) {
        Geometry ellipses = TestShapeFactory.createSlantedEllipses(new Coordinate(0.0, 0.0), 100.0, 10.0, NUM_GEOMS, npts);
        Geometry geom = TestShapeFactory.createExtentWithHoles(ellipses);
        System.out.println("\nRunning Slanted Ellipses: # geoms = " + NUM_GEOMS + ", # pts " + npts);
        return geom;
    }

    public void runValidate() {
        this.geom.isValid();
    }
}

