/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.SineStarFactory;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayNG;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;

public class OverlayNGSnapRoundingPerfTest
extends PerformanceTestCase {
    private static final int N_ITER = 1;
    static double ORG_X = 100.0;
    static double ORG_Y = 100.0;
    static double SIZE = 100.0;
    static int N_ARMS = 20;
    static double ARM_RATIO = 0.3;
    private Geometry sineStar;
    private PrecisionModel pm;
    private Geometry sineStar2;
    private int iter = 0;

    public static void main(String[] args) {
        PerformanceTestRunner.run(OverlayNGSnapRoundingPerfTest.class);
    }

    public OverlayNGSnapRoundingPerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{100, 200, 400, 1000, 2000, 4000, 8000, 10000, 100000, 200000, 400000, 1000000});
        this.setRunIterations(1);
    }

    @Override
    public void setUp() {
        System.out.println("OverlayNG Snap-Rounding perf test");
        System.out.println("SineStar: origin: (" + ORG_X + ", " + ORG_Y + ")  size: " + SIZE + "  # arms: " + N_ARMS + "  arm ratio: " + ARM_RATIO);
        System.out.println("# Iterations: 1");
    }

    @Override
    public void startRun(int npts) {
        this.iter = 0;
        this.sineStar = SineStarFactory.create((Coordinate)new Coordinate(ORG_X, ORG_Y), (double)SIZE, (int)npts, (int)N_ARMS, (double)ARM_RATIO);
        this.sineStar2 = SineStarFactory.create((Coordinate)new Coordinate(ORG_X + SIZE / 8.0, ORG_Y + SIZE / 8.0), (double)SIZE, (int)npts, (int)N_ARMS, (double)ARM_RATIO);
        double scale = (double)npts / SIZE;
        this.pm = new PrecisionModel(scale);
        System.out.format("\n# pts = %d, Scale = %f\n", npts, scale);
        if (npts <= 1000) {
            System.out.println(this.sineStar);
        }
    }

    public void runSR() {
        Geometry result = OverlayNG.overlay((Geometry)this.sineStar, (Geometry)this.sineStar2, (int)1, (PrecisionModel)this.pm);
    }

    public void xrunRobust() {
        Geometry result = OverlayNGRobust.overlay((Geometry)this.sineStar, (Geometry)this.sineStar2, (int)1);
    }

    public void xrunClassic() {
        Geometry result = this.sineStar.intersection(this.sineStar2);
    }
}

