/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.IntersectionMatrix;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.geom.prep.PreparedGeometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.SineStarFactory;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayNG;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;

public class OverlayNGPerfTest
extends PerformanceTestCase {
    private static final int PREC_SCALE_FACTOR = 1000000;
    private static final int N_ITER = 1;
    static double ORG_X;
    static double ORG_Y;
    static double SIZE;
    static int N_ARMS;
    static double ARM_RATIO;
    static int GRID_SIZE;
    static double GRID_CELL_SIZE;
    static int NUM_CASES;
    private Geometry geomA;
    private Geometry[] geomB;
    private PrecisionModel precisionModel;
    private int iter = 0;
    private static Geometry cacheKey;
    private static PreparedGeometry cache;

    public static void main(String[] args) {
        PerformanceTestRunner.run(OverlayNGPerfTest.class);
    }

    public OverlayNGPerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{100, 1000, 10000, 100000, 200000});
        this.setRunIterations(1);
    }

    @Override
    public void setUp() {
        System.out.println("OverlaySR perf test");
        System.out.println("SineStar: origin: (" + ORG_X + ", " + ORG_Y + ")  size: " + SIZE + "  # arms: " + N_ARMS + "  arm ratio: " + ARM_RATIO);
        System.out.println("# Iterations: 1");
        System.out.println("# B geoms: " + NUM_CASES);
        System.out.println("Precision scale: 1000000");
    }

    @Override
    public void startRun(int npts) {
        this.iter = 0;
        this.precisionModel = new PrecisionModel(1000000.0);
        this.geomA = SineStarFactory.create((Coordinate)new Coordinate(ORG_X, ORG_Y), (double)SIZE, (int)npts, (int)N_ARMS, (double)ARM_RATIO);
        int nptsB = npts / NUM_CASES;
        if (nptsB < 10) {
            nptsB = 10;
        }
        this.geomB = this.createTestGeoms(NUM_CASES, nptsB);
        System.out.println("\n-------  Running with A: # pts = " + npts + "   B # pts = " + nptsB);
        if (npts == 999) {
            System.out.println(this.geomA);
            for (Geometry g : this.geomB) {
                System.out.println(g);
            }
        }
    }

    private Geometry[] createTestGeoms(int nGeoms, int npts) {
        Geometry[] geoms = new Geometry[NUM_CASES];
        int index = 0;
        for (int i = 0; i < GRID_SIZE; ++i) {
            for (int j = 0; j < GRID_SIZE; ++j) {
                double x = GRID_CELL_SIZE / 2.0 + (double)i * GRID_CELL_SIZE;
                double y = GRID_CELL_SIZE / 2.0 + (double)j * GRID_CELL_SIZE;
                Geometry geom = SineStarFactory.create((Coordinate)new Coordinate(x, y), (double)GRID_CELL_SIZE, (int)npts, (int)N_ARMS, (double)ARM_RATIO);
                geoms[index++] = geom;
            }
        }
        return geoms;
    }

    public void runIntersectionOLD() {
        for (Geometry b : this.geomB) {
            this.geomA.intersection(b);
        }
    }

    public void xrunUnionNG() {
        for (Geometry b : this.geomB) {
            OverlayNG.overlay((Geometry)this.geomA, (Geometry)b, (int)2, (PrecisionModel)this.precisionModel);
        }
    }

    public void xrunUnionOLD() {
        for (Geometry b : this.geomB) {
            this.geomA.union(b);
        }
    }

    public void runIntersectionOLDOpt() {
        for (Geometry b : this.geomB) {
            OverlayNGPerfTest.intersectionOpt(this.geomA, b);
        }
    }

    public void runIntersectionNG() {
        for (Geometry b : this.geomB) {
            OverlayNG.overlay((Geometry)this.geomA, (Geometry)b, (int)1, (PrecisionModel)this.precisionModel);
        }
    }

    public void runIntersectionNGFloating() {
        for (Geometry b : this.geomB) {
            this.intersectionNGFloating(this.geomA, b);
        }
    }

    public void runIntersectionNGOpt() {
        for (Geometry b : this.geomB) {
            this.intersectionNGOpt(this.geomA, b);
        }
    }

    public void xrunIntersectionNGNoClip() {
        for (Geometry b : this.geomB) {
            this.intersectionNGNoClip(this.geomA, b);
        }
    }

    public void xrunIntersectionNGPrepNoCache() {
        for (Geometry b : this.geomB) {
            this.intersectionNGPrepNoCache(this.geomA, b);
        }
    }

    public void xrunIntersectionNGPrepNoCacheBA() {
        for (Geometry b : this.geomB) {
            this.intersectionNGPrepNoCache(b, this.geomA);
        }
    }

    public Geometry intersectionNGOpt(Geometry a, Geometry b) {
        Geometry intFast = OverlayNGPerfTest.fastIntersect(a, b);
        if (intFast != null) {
            return intFast;
        }
        return OverlayNG.overlay((Geometry)a, (Geometry)b, (int)1, (PrecisionModel)this.precisionModel);
    }

    public Geometry intersectionNGNoClip(Geometry a, Geometry b) {
        OverlayNG overlay = new OverlayNG(a, b, this.precisionModel, 1);
        overlay.setOptimized(false);
        return overlay.getResult();
    }

    public Geometry intersectionNGFloating(Geometry a, Geometry b) {
        OverlayNG overlay = new OverlayNG(a, b, 1);
        overlay.setOptimized(false);
        return overlay.getResult();
    }

    public Geometry intersectionNGPrep(Geometry a, Geometry b) {
        PreparedGeometry pg = OverlayNGPerfTest.cacheFetch(a);
        if (!pg.intersects(b)) {
            return null;
        }
        if (pg.covers(b)) {
            return b.copy();
        }
        return OverlayNG.overlay((Geometry)a, (Geometry)b, (int)1, (PrecisionModel)this.precisionModel);
    }

    public Geometry intersectionNGPrepNoCache(Geometry a, Geometry b) {
        Geometry intFast = this.fastintersectsPrepNoCache(a, b);
        if (intFast != null) {
            return intFast;
        }
        return OverlayNG.overlay((Geometry)a, (Geometry)b, (int)1, (PrecisionModel)this.precisionModel);
    }

    private Geometry fastintersectsPrepNoCache(Geometry a, Geometry b) {
        PreparedGeometry aPG = new PreparedGeometryFactory().create(a);
        if (!aPG.intersects(b)) {
            return a.getFactory().createEmpty(a.getDimension());
        }
        if (aPG.covers(b)) {
            return b.copy();
        }
        if (b.covers(a)) {
            return a.copy();
        }
        return null;
    }

    private static Geometry fastIntersect(Geometry a, Geometry b) {
        IntersectionMatrix im = a.relate(b);
        if (!im.isIntersects()) {
            return a.getFactory().createEmpty(a.getDimension());
        }
        if (im.isCovers()) {
            return b.copy();
        }
        if (im.isCoveredBy()) {
            return a.copy();
        }
        return null;
    }

    public static Geometry intersectionOpt(Geometry a, Geometry b) {
        Geometry intFast = OverlayNGPerfTest.fastIntersect(a, b);
        if (intFast != null) {
            return intFast;
        }
        return a.intersection(b);
    }

    public Geometry intersectionOptPrepNoCache(Geometry a, Geometry b) {
        Geometry intFast = this.fastintersectsPrepNoCache(a, b);
        if (intFast != null) {
            return intFast;
        }
        return a.intersection(b);
    }

    public static Geometry intersectionOptPrep(Geometry a, Geometry b) {
        PreparedGeometry pg = OverlayNGPerfTest.cacheFetch(a);
        if (!pg.intersects(b)) {
            return null;
        }
        if (pg.covers(b)) {
            return b.copy();
        }
        return a.intersection(b);
    }

    private static PreparedGeometry cacheFetch(Geometry g) {
        if (g != cacheKey) {
            cacheKey = g;
            cache = new PreparedGeometryFactory().create(g);
        }
        return cache;
    }

    static {
        ORG_Y = ORG_X = 100.0;
        SIZE = 2.0 * ORG_X;
        N_ARMS = 6;
        ARM_RATIO = 0.3;
        GRID_SIZE = 20;
        GRID_CELL_SIZE = SIZE / (double)GRID_SIZE;
        NUM_CASES = GRID_SIZE * GRID_SIZE;
        cacheKey = null;
        cache = null;
    }
}

