/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.overlay;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;

class RotatedRectangleFactory {
    private static double PI_OVER_2 = 1.5707963267948966;
    private GeometryFactory fact = new GeometryFactory();

    public Polygon createRectangle(double length, double width, double angle) {
        return this.createRectangle(length, width, angle, new Coordinate(0.0, 0.0));
    }

    public Polygon createRectangle(double length, double width, double angle, Coordinate base) {
        double posx = length / 2.0 * Math.cos(angle);
        double posy = length / 2.0 * Math.sin(angle);
        double negx = -posx;
        double negy = -posy;
        double widthOffsetx = width / 2.0 * Math.cos(angle + PI_OVER_2);
        double widthOffsety = width / 2.0 * Math.sin(angle + PI_OVER_2);
        Coordinate[] pts = new Coordinate[]{new Coordinate(base.x + posx + widthOffsetx, base.y + posy + widthOffsety), new Coordinate(base.x + posx - widthOffsetx, base.y + posy - widthOffsety), new Coordinate(base.x + negx - widthOffsetx, base.y + negy - widthOffsety), new Coordinate(base.x + negx + widthOffsetx, base.y + negy + widthOffsety), new Coordinate(0.0, 0.0)};
        pts[4] = new Coordinate(pts[0]);
        Polygon poly = this.fact.createPolygon(this.fact.createLinearRing(pts), null);
        return poly;
    }
}

