/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.distance;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.SineStarFactory;
import com.hazelcast.shaded.org.locationtech.jts.operation.distance.IndexedFacetDistance;
import com.hazelcast.shaded.org.locationtech.jts.util.GeometricShapeFactory;
import com.hazelcast.shaded.org.locationtech.jts.util.Stopwatch;

public class TestPerfDistanceGeomPair {
    static final int MAX_ITER = 100;
    boolean testFailed = false;
    boolean verbose = true;
    double size = 100.0;
    double separationDist = this.size * 2.0;

    public static void main(String[] args) {
        TestPerfDistanceGeomPair test = new TestPerfDistanceGeomPair();
        test.test2();
    }

    public void test() {
        this.test(10);
        this.test(10);
        this.test(100);
        this.test(500);
        this.test(1000);
        this.test(5000);
        this.test(10000);
        this.test(50000);
        this.test(100000);
    }

    public void test2() {
        this.verbose = false;
        for (int i = 100; i <= 2000; i += 100) {
            this.test(i);
        }
    }

    public void test(int nPts) {
        Geometry[] geom = this.createSineStars(nPts);
        if (this.verbose) {
            System.out.println("Running with " + nPts + " points");
        }
        if (!this.verbose) {
            System.out.print(nPts + ": ");
        }
        this.test(geom);
    }

    public void test(Geometry[] geom) {
        Stopwatch sw = new Stopwatch();
        double dist = 0.0;
        double dist2 = 0.0;
        for (int i = 0; i < 100; ++i) {
            this.computeDistanceToAllPoints(geom);
        }
        if (!this.verbose) {
            System.out.println(sw.getTimeString());
        }
        if (this.verbose) {
            System.out.println("Finished in " + sw.getTimeString());
            System.out.println("       (Distance = " + dist + ")");
        }
    }

    void computeDistanceToAllPoints(Geometry[] geom) {
        Coordinate[] pts = geom[1].getCoordinates();
        double dist = 0.0;
        double dist2 = 0.0;
        IndexedFacetDistance fastDist = new IndexedFacetDistance(geom[0]);
        for (int i = 0; i < pts.length; ++i) {
            Coordinate p = pts[i];
            dist = geom[0].distance((Geometry)geom[1].getFactory().createPoint(p));
        }
    }

    Geometry[] createCircles(int nPts) {
        GeometricShapeFactory gsf = new GeometricShapeFactory();
        gsf.setCentre(new Coordinate(0.0, 0.0));
        gsf.setSize(100.0);
        gsf.setNumPoints(nPts);
        Polygon gRect = gsf.createCircle();
        gsf.setCentre(new Coordinate(0.0, this.separationDist));
        Polygon gRect2 = gsf.createCircle();
        return new Geometry[]{gRect, gRect2};
    }

    Geometry[] createSineStars(int nPts) {
        SineStarFactory gsf = new SineStarFactory();
        gsf.setCentre(new Coordinate(0.0, 0.0));
        gsf.setSize(100.0);
        gsf.setNumPoints(nPts);
        Geometry g = gsf.createSineStar().getBoundary();
        gsf.setCentre(new Coordinate(0.0, this.separationDist));
        Geometry g2 = gsf.createSineStar().getBoundary();
        return new Geometry[]{g, g2};
    }
}

