/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.distance;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.SineStarFactory;
import com.hazelcast.shaded.org.locationtech.jts.operation.distance.DistanceOp;
import com.hazelcast.shaded.org.locationtech.jts.operation.distance.IndexedFacetDistance;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;
import test.jts.perf.operation.distance.CachedFastDistance;

public class DistanceGeomPairPerfTest
extends PerformanceTestCase {
    static final int MAX_ITER = 100;
    boolean testFailed = false;
    boolean verbose = true;
    static final double SIZE = 100.0;
    static final double OFFSET = 1000.0;
    private Geometry geom1;
    private Geometry geom2;
    private Point pt2;

    public static void main(String[] args) {
        PerformanceTestRunner.run(DistanceGeomPairPerfTest.class);
    }

    public DistanceGeomPairPerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000});
        this.setRunIterations(1000);
    }

    @Override
    public void startRun(int nPts) {
        int nPts2 = 100;
        System.out.println("\nRunning with " + nPts + " points (size-product = " + nPts * nPts2);
        this.geom1 = this.createSineStar(nPts, 0.0);
        this.geom2 = this.createSineStar(nPts2, 1000.0);
        this.pt2 = this.geom2.getCentroid();
    }

    public void runSimpleLines() {
        double dist = DistanceOp.distance((Geometry)this.geom1, (Geometry)this.geom2);
    }

    public void runIndexedLines() {
        double dist = IndexedFacetDistance.distance((Geometry)this.geom1, (Geometry)this.geom2);
    }

    public void runSimpleLinePoint() {
        double dist = DistanceOp.distance((Geometry)this.geom1, (Geometry)this.pt2);
    }

    public void runIndexedLinePoint() {
        double dist = IndexedFacetDistance.distance((Geometry)this.geom1, (Geometry)this.pt2);
    }

    public void runCachedLinePoint() {
        double dist = CachedFastDistance.getDistance(this.geom1, (Geometry)this.pt2);
    }

    Geometry createSineStar(int nPts, double offset) {
        SineStarFactory gsf = new SineStarFactory();
        gsf.setCentre(new Coordinate(0.0, 0.0));
        gsf.setSize(100.0);
        gsf.setNumPoints(nPts);
        gsf.setCentre(new Coordinate(0.0, offset));
        Geometry g2 = gsf.createSineStar().getBoundary();
        return g2;
    }
}

