/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.index;

import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.util.Assert;
import com.hazelcast.shaded.org.locationtech.jts.util.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import test.jts.perf.index.Index;

public class IndexTester {
    static final int NUM_ITEMS = 2000;
    static final double EXTENT_MIN = -1000.0;
    static final double EXTENT_MAX = 1000.0;
    Index index;
    private static final int SEED = 613;

    public IndexTester(Index index) {
        this.index = index;
    }

    public IndexResult testAll(List items, List queries) {
        IndexResult result = new IndexResult(this.index.toString());
        System.out.print(this.index.toString() + "           ");
        System.gc();
        Stopwatch sw = new Stopwatch();
        sw.start();
        this.loadTree(items);
        String loadTime = sw.getTimeString();
        result.loadMilliseconds = sw.getTime();
        System.gc();
        Stopwatch sw2 = new Stopwatch();
        this.runQuery(queries);
        String queryTime = sw2.getTimeString();
        result.queryMilliseconds = sw.getTime();
        System.out.println("  Load Time = " + loadTime + "  Query Time = " + queryTime);
        return result;
    }

    public static List createGridItems(int nGridCells) {
        double gridInc;
        ArrayList<Envelope> items = new ArrayList<Envelope>();
        int gridSize = (int)Math.sqrt(nGridCells);
        double extent = 2000.0;
        double cellSize = gridInc = extent / (double)(++gridSize);
        for (int i = 0; i < gridSize; ++i) {
            for (int j = 0; j < gridSize; ++j) {
                double x = -1000.0 + gridInc * (double)i;
                double y = -1000.0 + gridInc * (double)j;
                Envelope env = new Envelope(x, x + cellSize, y, y + cellSize);
                items.add(env);
            }
        }
        return items;
    }

    public static List createRandomBoxes(int n) {
        return IndexTester.createRandomBoxes(613, n);
    }

    public static List createRandomBoxes(int seed, int n) {
        Random random = new Random(seed);
        ArrayList<Envelope> items = new ArrayList<Envelope>();
        for (int i = 0; i < n; ++i) {
            items.add(IndexTester.createBox(random));
        }
        return items;
    }

    private static Envelope createBox(Random random) {
        double minX = IndexTester.randomDouble(random, -100.0, 100.0);
        double minY = IndexTester.randomDouble(random, -100.0, 100.0);
        double sizeX = IndexTester.randomDouble(random, 0.0, 10.0);
        double sizeY = IndexTester.randomDouble(random, 0.0, 10.0);
        return new Envelope(minX, minX + sizeX, minY, minY + sizeY);
    }

    private static double randomDouble(Random random, double min, double max) {
        return min + random.nextDouble() * (max - min);
    }

    void loadTree(List items) {
        for (Envelope item : items) {
            this.index.insert(item, item);
        }
        this.index.finishInserting();
    }

    void runQuery(List queries) {
        double querySize = 0.0;
        for (int i = 0; i < queries.size(); ++i) {
            Envelope env = (Envelope)queries.get(i);
            List list = this.index.query(env);
            Assert.isTrue((!list.isEmpty() ? 1 : 0) != 0);
            querySize += (double)list.size();
        }
        System.out.println("Avg query size = " + querySize / (double)queries.size());
    }

    void runGridQuery(int nGridCells) {
        int cellSize = (int)Math.sqrt(2000.0);
        double extent = 2000.0;
        double queryCellSize = 2.0 * extent / (double)cellSize;
        this.queryGrid(nGridCells, queryCellSize);
    }

    void queryGrid(int nGridCells, double cellSize) {
        int gridSize = (int)Math.sqrt(nGridCells);
        double extent = 2000.0;
        double gridInc = extent / (double)(++gridSize);
        for (int i = 0; i < gridSize; ++i) {
            for (int j = 0; j < gridSize; ++j) {
                double x = -1000.0 + gridInc * (double)i;
                double y = -1000.0 + gridInc * (double)j;
                Envelope env = new Envelope(x, x + cellSize, y, y + cellSize);
                this.index.query(env);
            }
        }
    }

    public static class IndexResult {
        public String indexName;
        public long loadMilliseconds;
        public long queryMilliseconds;

        public IndexResult(String indexName) {
            this.indexName = indexName;
        }
    }
}

