/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.geom.prep;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.geom.prep.PreparedGeometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.SineStarFactory;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTWriter;
import com.hazelcast.shaded.org.locationtech.jts.util.GeometricShapeFactory;
import com.hazelcast.shaded.org.locationtech.jts.util.Stopwatch;
import java.util.ArrayList;
import java.util.List;

public class PreparedPolygonIntersectsPerfTest {
    static final int MAX_ITER = 10;
    static final int NUM_AOI_PTS = 2000;
    static final int NUM_LINES = 10000;
    static final int NUM_LINE_PTS = 100;
    static PrecisionModel pm = new PrecisionModel();
    static GeometryFactory fact = new GeometryFactory(pm, 0);
    static WKTReader wktRdr = new WKTReader(fact);
    static WKTWriter wktWriter = new WKTWriter();
    Stopwatch sw = new Stopwatch();
    boolean testFailed = false;

    public static void main(String[] args) {
        PreparedPolygonIntersectsPerfTest test = new PreparedPolygonIntersectsPerfTest();
        test.test();
    }

    public void test() {
        this.test(5);
        this.test(10);
        this.test(500);
        this.test(1000);
        this.test(2000);
        this.test(4000);
    }

    public void test(int nPts) {
        Geometry sinePoly;
        Geometry target = sinePoly = this.createSineStar(new Coordinate(0.0, 0.0), 100.0, nPts);
        List lines = this.createLines(target.getEnvelopeInternal(), 10000, 1.0, 100);
        System.out.println();
        this.test(target, lines);
    }

    Geometry createCircle(Coordinate origin, double size, int nPts) {
        GeometricShapeFactory gsf = new GeometricShapeFactory();
        gsf.setCentre(origin);
        gsf.setSize(size);
        gsf.setNumPoints(nPts);
        Polygon circle = gsf.createCircle();
        return circle;
    }

    Geometry createSineStar(Coordinate origin, double size, int nPts) {
        SineStarFactory gsf = new SineStarFactory();
        gsf.setCentre(origin);
        gsf.setSize(size);
        gsf.setNumPoints(nPts);
        gsf.setArmLengthRatio(0.1);
        gsf.setNumArms(50);
        Geometry poly = gsf.createSineStar();
        return poly;
    }

    List createLines(Envelope env, int nItems, double size, int nPts) {
        int nCells = (int)Math.sqrt(nItems);
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        double width = env.getWidth();
        double xInc = width / (double)nCells;
        double yInc = width / (double)nCells;
        for (int i = 0; i < nCells; ++i) {
            for (int j = 0; j < nCells; ++j) {
                Coordinate base = new Coordinate(env.getMinX() + (double)i * xInc, env.getMinY() + (double)j * yInc);
                Geometry line = this.createLine(base, size, nPts);
                geoms.add(line);
            }
        }
        return geoms;
    }

    Geometry createLine(Coordinate base, double size, int nPts) {
        SineStarFactory gsf = new SineStarFactory();
        gsf.setCentre(base);
        gsf.setSize(size);
        gsf.setNumPoints(nPts);
        Geometry circle = gsf.createSineStar();
        return circle.getBoundary();
    }

    public void test(Geometry g, List lines) {
        System.out.println("AOI # pts: " + g.getNumPoints() + "      # lines: " + lines.size() + "   # pts in line: " + 100);
        Stopwatch sw = new Stopwatch();
        int count = 0;
        for (int i = 0; i < 10; ++i) {
            count = this.testPrepGeomCached(i, g, lines);
        }
        System.out.println("Count of intersections = " + count);
        System.out.println("Finished in " + sw.getTimeString());
    }

    public int testOriginal(int iter, Geometry g, List lines) {
        if (iter == 0) {
            System.out.println("Using original JTS algorithm");
        }
        int count = 0;
        for (LineString line : lines) {
            if (!g.intersects((Geometry)line)) continue;
            ++count;
        }
        return count;
    }

    public int testPrepGeomCached(int iter, Geometry g, List lines) {
        if (iter == 0) {
            System.out.println("Using cached Prepared Geometry");
        }
        PreparedGeometryFactory pgFact = new PreparedGeometryFactory();
        PreparedGeometry prepGeom = pgFact.create(g);
        int count = 0;
        for (LineString line : lines) {
            if (!prepGeom.intersects((Geometry)line)) continue;
            ++count;
        }
        return count;
    }

    public int testPrepGeomNotCached(int iter, Geometry g, List lines) {
        if (iter == 0) {
            System.out.println("Using NON-CACHED Prepared Geometry");
        }
        PreparedGeometryFactory pgFact = new PreparedGeometryFactory();
        int count = 0;
        for (LineString line : lines) {
            PreparedGeometry prepGeom = pgFact.create(g);
            if (!prepGeom.intersects((Geometry)line)) continue;
            ++count;
        }
        return count;
    }
}

